/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Table;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.metadata.ClassMetadata;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.AllRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.opennms.netmgt.dao.hibernate.AccessLock;
import org.opennms.netmgt.dao.hibernate.HibernateCriteriaConverter;
import org.opennms.netmgt.model.OnmsCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class AbstractDaoHibernate<T, K extends Serializable>
extends HibernateDaoSupport
implements OnmsDao<T, K> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDaoHibernate.class);
    Class<T> m_entityClass;
    private String m_lockName;
    protected final HibernateCriteriaConverter m_criteriaConverter = new HibernateCriteriaConverter();

    public AbstractDaoHibernate(Class<T> entityClass) {
        this.m_entityClass = entityClass;
        Table table = this.m_entityClass.getAnnotation(Table.class);
        this.m_lockName = (table == null || "".equals(table.name()) ? this.m_entityClass.getSimpleName() : table.name()).toUpperCase() + "_ACCESS";
    }

    protected void initDao() throws Exception {
        this.getHibernateTemplate().saveOrUpdate((Object)new AccessLock(this.m_lockName));
    }

    public void lock() {
        this.getHibernateTemplate().get(AccessLock.class, (Serializable)((Object)this.m_lockName), LockMode.PESSIMISTIC_WRITE);
    }

    public void initialize(Object obj) {
        this.getHibernateTemplate().initialize(obj);
    }

    public void flush() {
        this.getHibernateTemplate().flush();
    }

    public void clear() {
        this.getHibernateTemplate().flush();
        this.getHibernateTemplate().clear();
    }

    public void merge(T entity) {
        this.getHibernateTemplate().merge(entity);
    }

    public List<T> find(String query) {
        return this.getHibernateTemplate().find(query);
    }

    public List<T> find(String query, Object ... values) {
        return this.getHibernateTemplate().find(query, values);
    }

    public <S> List<S> findObjects(Class<S> clazz, String query, Object ... values) {
        List notifs = this.getHibernateTemplate().find(query, values);
        return notifs;
    }

    protected int queryInt(final String query) {
        HibernateCallback<Number> callback = new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.createQuery(query).uniqueResult();
            }
        };
        return ((Number)this.getHibernateTemplate().execute((HibernateCallback)callback)).intValue();
    }

    protected int queryInt(final String queryString, final Object ... args) {
        HibernateCallback<Number> callback = new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                for (int i = 0; i < args.length; ++i) {
                    query.setParameter(i, args[i]);
                }
                return (Number)query.uniqueResult();
            }
        };
        return ((Number)this.getHibernateTemplate().execute((HibernateCallback)callback)).intValue();
    }

    protected T findUnique(final String queryString, final Object ... args) {
        final Class<T> type = this.m_entityClass;
        HibernateCallback callback = new HibernateCallback<T>(){

            public T doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                for (int i = 0; i < args.length; ++i) {
                    query.setParameter(i, args[i]);
                }
                Object result = query.uniqueResult();
                return result == null ? null : (Object)type.cast(result);
            }
        };
        return (T)this.getHibernateTemplate().execute(callback);
    }

    public int countAll() {
        return this.queryInt("select count(*) from " + this.m_entityClass.getName());
    }

    public void delete(T entity) throws DataAccessException {
        this.getHibernateTemplate().delete(entity);
    }

    public void delete(K key) throws DataAccessException {
        this.delete((K)this.get(key));
    }

    public void deleteAll(Collection<T> entities) throws DataAccessException {
        this.getHibernateTemplate().deleteAll(entities);
    }

    public List<T> findAll() throws DataAccessException {
        return this.getHibernateTemplate().loadAll(this.m_entityClass);
    }

    public List<T> findMatching(Criteria criteria) {
        if (criteria.isMultipleAnd()) {
            return this.findMultiAndMatching(criteria);
        }
        HibernateCallback<List<T>> callback = this.buildHibernateCallback(criteria);
        return (List)this.getHibernateTemplate().execute(callback);
    }

    private List<T> findMultiAndMatching(Criteria criteria) {
        LinkedHashSet allUniqueRecords = new LinkedHashSet();
        Collection allRestrictions = criteria.getRestrictions();
        Set multiAndRestrictionSet = allRestrictions.stream().filter(restriction -> restriction.getType().equals((Object)Restriction.RestrictionType.MULTIAND)).collect(Collectors.toSet());
        Sets.SetView nonMultiAndRestrictionSet = Sets.difference(new HashSet(allRestrictions), multiAndRestrictionSet);
        multiAndRestrictionSet.stream().forEach(arg_0 -> this.lambda$findMultiAndMatching$2(criteria, (Set)nonMultiAndRestrictionSet, allUniqueRecords, arg_0));
        return Arrays.asList(allUniqueRecords.toArray());
    }

    private List<T> getQueryResult(Criteria criteria) {
        try {
            HibernateCallback<List<T>> callback = this.buildHibernateCallback(criteria);
            return (List)this.getHibernateTemplate().execute(callback);
        }
        catch (Exception ex) {
            LOG.error("Error in execution of query", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    protected <T> HibernateCallback<List<T>> buildHibernateCallback(final Criteria criteria) {
        return new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException, SQLException {
                LOG.debug("criteria = {}", (Object)criteria);
                org.hibernate.Criteria hibernateCriteria = AbstractDaoHibernate.this.m_criteriaConverter.convert(criteria, session);
                return hibernateCriteria.list();
            }
        };
    }

    public int countMatching(final Criteria criteria) throws DataAccessException {
        HibernateCallback<Integer> callback = new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Criteria hibernateCriteria = AbstractDaoHibernate.this.m_criteriaConverter.convertForCount(criteria, session);
                hibernateCriteria.setProjection(Projections.rowCount());
                Long retval = (Long)hibernateCriteria.uniqueResult();
                hibernateCriteria.setProjection(null);
                hibernateCriteria.setResultTransformer(org.hibernate.Criteria.ROOT_ENTITY);
                return retval.intValue();
            }
        };
        Integer retval = (Integer)this.getHibernateTemplate().execute((HibernateCallback)callback);
        return retval == null ? 0 : retval;
    }

    public List<T> findMatching(final OnmsCriteria onmsCrit) throws DataAccessException {
        onmsCrit.resultsOfType(this.m_entityClass);
        HibernateCallback callback = new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Criteria attachedCrit = onmsCrit.getDetachedCriteria().getExecutableCriteria(session);
                if (onmsCrit.getFirstResult() != null) {
                    attachedCrit.setFirstResult(onmsCrit.getFirstResult().intValue());
                }
                if (onmsCrit.getMaxResults() != null) {
                    attachedCrit.setMaxResults(onmsCrit.getMaxResults().intValue());
                }
                return attachedCrit.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(callback);
    }

    public int countMatching(final OnmsCriteria onmsCrit) throws DataAccessException {
        HibernateCallback<Integer> callback = new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Criteria attachedCrit = onmsCrit.getDetachedCriteria().getExecutableCriteria(session).setProjection(Projections.rowCount());
                Long retval = (Long)attachedCrit.uniqueResult();
                attachedCrit.setProjection(null);
                attachedCrit.setResultTransformer(org.hibernate.Criteria.ROOT_ENTITY);
                return retval.intValue();
            }
        };
        Integer retval = (Integer)this.getHibernateTemplate().execute((HibernateCallback)callback);
        return retval == null ? 0 : retval;
    }

    public int bulkDelete(String hql, Object[] values) throws DataAccessException {
        return this.getHibernateTemplate().bulkUpdate(hql, values);
    }

    public T get(K id) throws DataAccessException {
        return this.m_entityClass.cast(this.getHibernateTemplate().get(this.m_entityClass, id));
    }

    public T load(K id) throws DataAccessException {
        return this.m_entityClass.cast(this.getHibernateTemplate().load(this.m_entityClass, id));
    }

    public K save(T entity) throws DataAccessException {
        try {
            return (K)this.getHibernateTemplate().save(entity);
        }
        catch (DataAccessException e) {
            this.logExtraSaveOrUpdateExceptionInformation(entity, e);
            throw e;
        }
    }

    public void saveOrUpdate(T entity) throws DataAccessException {
        try {
            this.getHibernateTemplate().saveOrUpdate(entity);
        }
        catch (DataAccessException e) {
            this.logExtraSaveOrUpdateExceptionInformation(entity, e);
            throw e;
        }
    }

    public void update(T entity) throws DataAccessException {
        try {
            this.getHibernateTemplate().update(entity);
        }
        catch (DataAccessException e) {
            this.logExtraSaveOrUpdateExceptionInformation(entity, e);
            throw e;
        }
    }

    private void logExtraSaveOrUpdateExceptionInformation(T entity, DataAccessException e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            if (cause.getMessage() != null) {
                if (cause.getMessage().contains("duplicate key value violates unique constraint")) {
                    ClassMetadata meta = this.getSessionFactory().getClassMetadata(this.m_entityClass);
                    LOG.warn("Duplicate key constraint violation, class: {}, key value: {}", (Object)this.m_entityClass.getName(), meta.getPropertyValue(entity, meta.getIdentifierPropertyName(), EntityMode.POJO));
                    break;
                }
                if (cause.getMessage().contains("given object has a null identifier")) {
                    LOG.warn("Null identifier on object, class: {}: {}", (Object)this.m_entityClass.getName(), (Object)entity.toString());
                    break;
                }
            }
            cause = cause.getCause();
        }
    }

    public List<T> findWithPagination(String query, Object[] values, int offset, int limit) {
        return (List)this.getHibernateTemplate().execute(session -> {
            Query hqlQuery = session.createQuery(query);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    hqlQuery.setParameter(i, values[i]);
                }
            }
            hqlQuery.setFirstResult(offset);
            hqlQuery.setMaxResults(limit);
            return hqlQuery.list();
        });
    }

    private /* synthetic */ void lambda$findMultiAndMatching$2(Criteria criteria, Set nonMultiAndRestrictionSet, Set allUniqueRecords, Restriction restriction) {
        Collection allMultiAndRestrictions = ((AllRestriction)restriction).getRestrictions();
        allMultiAndRestrictions.stream().forEach(singleMultiAndRestriction -> {
            Criteria copyOfCriteria = criteria.clone();
            copyOfCriteria.setRestrictions((Collection)nonMultiAndRestrictionSet);
            copyOfCriteria.addRestriction(singleMultiAndRestriction);
            if (allUniqueRecords.isEmpty()) {
                allUniqueRecords.addAll(this.getQueryResult(copyOfCriteria));
            } else {
                allUniqueRecords.addAll(Sets.intersection((Set)allUniqueRecords, Set.copyOf(this.getQueryResult(copyOfCriteria))));
            }
        });
    }
}

