/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="service-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="service-configuration.xsd")
public class ServiceConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(ServiceConfiguration.class);
    private static final String DEFAULT_CONFIG_RESOURCE = "/defaults/service-configuration.xml";
    @XmlElement(name="service")
    private List<Service> m_services = new ArrayList<Service>();

    public ServiceConfiguration() {
    }

    public ServiceConfiguration(List<Service> services) {
        this.setServices(services);
    }

    public List<Service> getServices() {
        return this.m_services;
    }

    public void setServices(List<Service> services) {
        if (services == this.m_services) {
            return;
        }
        this.m_services.clear();
        if (services != null) {
            this.m_services.addAll(services);
        }
    }

    public void addService(Service service) {
        this.m_services.add(service);
    }

    public boolean removeService(Service service) {
        return this.m_services.remove(service);
    }

    public int hashCode() {
        return Objects.hash(this.m_services);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceConfiguration) {
            ServiceConfiguration that = (ServiceConfiguration)obj;
            return Objects.equals(this.m_services, that.m_services);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ServiceConfiguration loadDefaults() {
        try (InputStream is = ServiceConfiguration.class.getResourceAsStream(DEFAULT_CONFIG_RESOURCE);){
            if (is == null) {
                LOG.warn("Default service configuration not found at: {}", (Object)DEFAULT_CONFIG_RESOURCE);
                ServiceConfiguration serviceConfiguration2 = null;
                return serviceConfiguration2;
            }
            ServiceConfiguration serviceConfiguration = (ServiceConfiguration)JaxbUtils.unmarshal(ServiceConfiguration.class, (InputStream)is);
            return serviceConfiguration;
        }
        catch (IOException e) {
            LOG.error("Failed to load default service configuration from: {}", (Object)DEFAULT_CONFIG_RESOURCE, (Object)e);
            return null;
        }
    }

    public static ServiceConfiguration mergeWithDefaults(ServiceConfiguration userConfig) {
        if (userConfig == null) {
            return ServiceConfiguration.loadDefaults();
        }
        ServiceConfiguration defaults = ServiceConfiguration.loadDefaults();
        if (defaults == null) {
            LOG.warn("No default configuration found, using user configuration as-is");
            return userConfig;
        }
        HashMap<String, Service> defaultServiceMap = new HashMap<String, Service>();
        for (Service service : defaults.getServices()) {
            defaultServiceMap.put(service.getName(), service);
        }
        ServiceConfiguration merged = new ServiceConfiguration();
        for (Service userService : userConfig.getServices()) {
            Service defaultService = (Service)defaultServiceMap.get(userService.getName());
            Service mergedService = Service.merge(userService, defaultService);
            merged.addService(mergedService);
        }
        return merged;
    }
}

