/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.reportd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.reportd.Parameter;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="report")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="reportd-configuration.xsd")
public class Report
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final List<String> REPORT_FORMAT_TYPES = Arrays.asList("pdf", "csv", "html");
    private static final List<String> REPORT_ENGINE_TYPES = Arrays.asList("jdbc", "opennms");
    private static final String DEFAULT_REPORT_FORMAT = "pdf";
    private static final String DEFAULT_REPORT_ENGINE = "opennms";
    @XmlAttribute(name="report-template", required=true)
    private String m_reportTemplate;
    @XmlAttribute(name="report-name", required=true)
    private String m_reportName;
    @XmlAttribute(name="report-format")
    private String m_reportFormat;
    @XmlAttribute(name="report-engine")
    private String m_reportEngine;
    @XmlElement(name="cron-schedule", required=true)
    private String m_cronSchedule;
    @XmlElement(name="recipient")
    private List<String> m_recipients = new ArrayList<String>();
    @XmlElement(name="mailer")
    private String m_mailer;
    @XmlElement(name="parameter")
    private List<Parameter> m_parameters = new ArrayList<Parameter>();

    public String getReportTemplate() {
        return this.m_reportTemplate;
    }

    public void setReportTemplate(String reportTemplate) {
        this.m_reportTemplate = ConfigUtils.assertNotEmpty(reportTemplate, "report-template");
    }

    public String getReportName() {
        return this.m_reportName;
    }

    public void setReportName(String reportName) {
        this.m_reportName = ConfigUtils.assertNotEmpty(reportName, "report-name");
    }

    public String getReportFormat() {
        return this.m_reportFormat != null ? this.m_reportFormat : DEFAULT_REPORT_FORMAT;
    }

    public void setReportFormat(String reportFormat) {
        this.m_reportFormat = ConfigUtils.assertOnlyContains(reportFormat, REPORT_FORMAT_TYPES, "report-format");
    }

    public String getReportEngine() {
        return this.m_reportEngine != null ? this.m_reportEngine : DEFAULT_REPORT_ENGINE;
    }

    public void setReportEngine(String reportEngine) {
        this.m_reportEngine = ConfigUtils.assertOnlyContains(reportEngine, REPORT_ENGINE_TYPES, "report-engine");
    }

    public String getCronSchedule() {
        return this.m_cronSchedule;
    }

    public void setCronSchedule(String cronSchedule) {
        this.m_cronSchedule = ConfigUtils.assertNotEmpty(cronSchedule, "cron-schedule");
    }

    public List<String> getRecipients() {
        return this.m_recipients;
    }

    public void setRecipients(List<String> recipients) {
        if (recipients == this.m_recipients) {
            return;
        }
        this.m_recipients.clear();
        if (recipients != null) {
            this.m_recipients.addAll(recipients);
        }
    }

    public void addRecipient(String recipient) {
        this.m_recipients.add(recipient);
    }

    public boolean removeRecipient(String recipient) {
        return this.m_recipients.remove(recipient);
    }

    public Optional<String> getMailer() {
        return Optional.ofNullable(this.m_mailer);
    }

    public void setMailer(String mailer) {
        this.m_mailer = ConfigUtils.assertNotEmpty(mailer, "mailer");
    }

    public List<Parameter> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        if (parameters == this.m_parameters) {
            return;
        }
        this.m_parameters.clear();
        if (parameters != null) {
            this.m_parameters.addAll(parameters);
        }
    }

    public void addParameter(Parameter parameter) {
        this.m_parameters.add(parameter);
    }

    public boolean removeParameter(Parameter parameter) {
        return this.m_parameters.remove(parameter);
    }

    public int hashCode() {
        return Objects.hash(this.m_reportTemplate, this.m_reportName, this.m_reportFormat, this.m_reportEngine, this.m_cronSchedule, this.m_recipients, this.m_mailer, this.m_parameters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Report) {
            Report that = (Report)obj;
            return Objects.equals(this.m_reportTemplate, that.m_reportTemplate) && Objects.equals(this.m_reportName, that.m_reportName) && Objects.equals(this.m_reportFormat, that.m_reportFormat) && Objects.equals(this.m_reportEngine, that.m_reportEngine) && Objects.equals(this.m_cronSchedule, that.m_cronSchedule) && Objects.equals(this.m_recipients, that.m_recipients) && Objects.equals(this.m_mailer, that.m_mailer) && Objects.equals(this.m_parameters, that.m_parameters);
        }
        return false;
    }
}

