/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.mailtransporttest;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.mailtransporttest.ReadmailProtocol;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="readmail-host")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="mail-transport-test.xsd")
public class ReadmailHost
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="host")
    private String m_host;
    @XmlAttribute(name="port")
    private Long m_port;
    @XmlElement(name="readmail-protocol", required=true)
    private ReadmailProtocol m_readmailProtocol;

    public ReadmailHost() {
    }

    public ReadmailHost(String host, Long port) {
        this.setHost(host);
        this.setPort(port);
    }

    public String getHost() {
        return this.m_host == null ? "${ipaddr}" : this.m_host;
    }

    public void setHost(String host) {
        this.m_host = ConfigUtils.normalizeString(host);
    }

    public Long getPort() {
        return this.m_port == null ? 110L : this.m_port;
    }

    public void setPort(Long port) {
        this.m_port = port;
    }

    public ReadmailProtocol getReadmailProtocol() {
        return this.m_readmailProtocol;
    }

    public void setReadmailProtocol(ReadmailProtocol readmailProtocol) {
        this.m_readmailProtocol = ConfigUtils.assertNotNull(readmailProtocol, "readmail-protocol");
    }

    public int hashCode() {
        return Objects.hash(this.m_host, this.m_port, this.m_readmailProtocol);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReadmailHost) {
            ReadmailHost that = (ReadmailHost)obj;
            return Objects.equals(this.m_host, that.m_host) && Objects.equals(this.m_port, that.m_port) && Objects.equals(this.m_readmailProtocol, that.m_readmailProtocol);
        }
        return false;
    }
}

