/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

class ToStringBuilder {
    final StringBuilder buf = new StringBuilder(512);
    boolean first = true;
    boolean finished = false;

    public ToStringBuilder(Object o) {
        this.buf.append(o.getClass().getSimpleName());
        this.buf.append('@');
        this.buf.append(String.format("%x", System.identityHashCode(o)));
        this.buf.append('[');
    }

    public ToStringBuilder append(String label, String value) {
        this.assertNotFinished();
        if (!this.first) {
            this.buf.append(", ");
        } else {
            this.first = false;
        }
        this.buf.append(label).append('=').append(value);
        return this;
    }

    public ToStringBuilder append(String label, Object value) {
        return this.append(label, value == null ? null : value.toString());
    }

    public String toString() {
        if (!this.finished) {
            this.buf.append(']');
            this.finished = true;
        }
        return this.buf.toString();
    }

    private void assertNotFinished() {
        if (this.finished) {
            throw new IllegalStateException("This builder has already been completed by calling toString");
        }
    }
}

