/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpGetter
extends TableTracker {
    private final SnmpAgentConfig m_agentConfig;
    private final LocationAwareSnmpClient m_client;
    private final String m_location;
    private static final Logger LOG = LoggerFactory.getLogger(SnmpGetter.class);

    public SnmpGetter(SnmpAgentConfig peer, LocationAwareSnmpClient client, String location) {
        super(new SnmpObjId[0]);
        this.m_agentConfig = peer;
        this.m_client = client;
        this.m_location = location;
    }

    public SnmpValue get(SnmpObjId entryoid, Integer index) {
        SnmpObjId instance = SnmpObjId.get(new int[]{index});
        ArrayList<SnmpObjId> oids = new ArrayList<SnmpObjId>(1);
        oids.add(SnmpObjId.get(entryoid, instance));
        List<SnmpValue> val = this.get(oids);
        if (val == null || val.size() != 1 || val.get(0) == null || val.get(0).isError()) {
            return null;
        }
        return val.get(0);
    }

    public List<SnmpValue> get(List<SnmpObjId> entryoids, Integer index) {
        SnmpObjId instance = SnmpObjId.get(new int[]{index});
        ArrayList<SnmpObjId> oids = new ArrayList<SnmpObjId>(entryoids.size());
        for (SnmpObjId entryoid : entryoids) {
            oids.add(SnmpObjId.get(entryoid, instance));
        }
        return this.get(oids);
    }

    public List<SnmpValue> get(List<SnmpObjId> oids) {
        List<SnmpValue> val;
        LOG.debug("get: oids '{}'", oids);
        try {
            val = this.m_client.get(this.m_agentConfig, oids).withLocation(this.m_location).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("get: InterruptedException: snmp GET {}: {}", oids, (Object)e.getMessage());
            return null;
        }
        catch (ExecutionException e) {
            LOG.error("get: ExecutionException: snmp GET {}: {}", oids, (Object)e.getMessage());
            return null;
        }
        LOG.debug("get: oid '{}' found value '{}'", oids, val);
        if (val == null || val.size() != oids.size()) {
            return null;
        }
        return val;
    }
}

