/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.opennms.features.config.dao.api.ConfigConverter;
import org.opennms.features.config.dao.api.ConfigData;
import org.opennms.features.config.dao.api.ConfigDefinition;
import org.opennms.features.config.dao.impl.util.XsdHelper;
import org.opennms.features.config.exception.ConfigNotFoundException;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.opennms.features.config.service.api.EventType;
import org.opennms.features.config.service.api.JsonAsString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationManagerServiceMock
implements ConfigurationManagerService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationManagerServiceMock.class);
    public static final String JSON_EXTENSION = ".json";
    public static final String XML_EXTENSION = ".xml";
    private final Map<String, Map<String, String>> configStore = new HashMap<String, Map<String, String>>();
    private Map<String, String> configFileMap;

    public void setConfigFileMap(Map<String, String> configFileMap) {
        this.configFileMap = configFileMap;
    }

    public void registerConfigDefinition(String configName, ConfigDefinition configDefinition) {
    }

    public void changeConfigDefinition(String configName, ConfigDefinition configDefinition) {
    }

    public Map<String, ConfigDefinition> getAllConfigDefinitions() {
        return Collections.emptyMap();
    }

    public Optional<ConfigDefinition> getRegisteredConfigDefinition(String configName) {
        ConfigDefinition def = null;
        if ("provisiond".equals(configName)) {
            def = XsdHelper.buildConfigDefinition((String)"provisiond", (String)"provisiond-configuration.xsd", (String)"provisiond-configuration", (String)"/rest/cm");
        }
        return Optional.ofNullable(def);
    }

    public void registerEventHandler(EventType type, ConfigUpdateInfo info, Consumer<ConfigUpdateInfo> consumer) {
    }

    public void registerConfiguration(String configName, String configId, JsonAsString configObject) {
        this.putConfig(configName, configId, configObject.toString());
    }

    public void unregisterConfiguration(String configName, String configId) {
    }

    public void updateConfiguration(String configName, String configId, JsonAsString configObject, boolean isReplace) {
        this.putConfig(configName, configId, configObject.toString());
    }

    private String getConfig(String configName, String configId) {
        Map<String, String> configs = this.configStore.get(configName);
        if (configs == null) {
            return null;
        }
        return configs.get(configId);
    }

    private void putConfig(String configName, String configId, String json) {
        Map configs = this.configStore.computeIfAbsent(configName, value -> new HashMap());
        configs.put(configId, json);
    }

    public Optional<JSONObject> getJSONConfiguration(String configName, String configId) {
        Optional<String> jsonStr = this.getJSONStrConfiguration(configName, configId);
        if (jsonStr.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new JSONObject(jsonStr.get()));
    }

    public Optional<String> getJSONStrConfiguration(String configName, String configId) {
        String jsonStr = this.getConfig(configName, configId);
        if (jsonStr != null) {
            return Optional.of(jsonStr);
        }
        ArrayList<String> paths = new ArrayList<String>();
        if (this.configFileMap != null && this.configFileMap.containsKey(configName)) {
            paths.add(this.configFileMap.get(configName));
        }
        paths.add("etc/" + configName + "-" + configId + JSON_EXTENSION);
        paths.add("mock/" + configName + "-" + configId + JSON_EXTENSION);
        String tmpConfigFile = this.findConfigFile(paths);
        if (tmpConfigFile != null && tmpConfigFile.endsWith(JSON_EXTENSION)) {
            try {
                InputStream in = ConfigurationManagerServiceMock.class.getClassLoader().getResourceAsStream(tmpConfigFile);
                if (in != null) {
                    jsonStr = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                }
            }
            catch (IOException e) {
                LOG.error("FAIL to read file: {} message: {}", (Object)tmpConfigFile, (Object)e.getMessage());
            }
        }
        if (jsonStr == null) {
            String xmlStr = this.getXmlConfiguration(configName, configId);
            if (xmlStr == null) {
                LOG.error("Cannot found config !!! configName: {}, configId: {}. Returning empty config.", (Object)configName, (Object)configId);
                return Optional.of("{}");
            }
            Optional<ConfigDefinition> def = this.getRegisteredConfigDefinition(configName);
            if (def.isEmpty()) {
                LOG.error("Cannot find ConfigDefinition for {}. ", (Object)configName);
                throw new ConfigNotFoundException("ConfigDefinition not found!");
            }
            try {
                ConfigConverter converter = XsdHelper.getConverter((ConfigDefinition)def.get());
                jsonStr = converter.xmlToJson(xmlStr);
            }
            catch (IOException e) {
                LOG.error("FAIL to convert xml: {}, message: {}", (Object)xmlStr, (Object)e.getMessage());
            }
        }
        if (jsonStr != null) {
            this.putConfig(configName, configId, jsonStr);
        }
        return Optional.ofNullable(jsonStr);
    }

    private String getXmlConfiguration(String configName, String configId) {
        String tmpConfigFile;
        String configFile;
        String string = configFile = this.configFileMap != null ? this.configFileMap.get(configName) : null;
        if (configFile == null) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add("etc/" + configName + "-" + configId + XML_EXTENSION);
            paths.add("defaults/" + configName + "-configuration.xml");
            paths.add("defaults/" + configName + "-config.xml");
            tmpConfigFile = this.findConfigFile(paths);
        } else {
            tmpConfigFile = configFile;
        }
        if (tmpConfigFile == null) {
            return null;
        }
        try {
            InputStream in = tmpConfigFile.startsWith("/") ? new FileInputStream(tmpConfigFile) : ConfigurationManagerServiceMock.class.getClassLoader().getResourceAsStream(tmpConfigFile);
            String xmlStr = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            LOG.debug("xmlStr: {}", (Object)xmlStr);
            return xmlStr;
        }
        catch (Exception e) {
            LOG.error("FAIL TO LOAD XML: {}", (Object)configFile, (Object)e);
            return null;
        }
    }

    private String findConfigFile(List<String> paths) {
        if (paths == null) {
            return null;
        }
        AtomicReference fileFound = new AtomicReference();
        paths.forEach(path -> {
            if (fileFound.get() != null) {
                return;
            }
            if (path == null) {
                return;
            }
            File tmpFile = new File((String)path);
            if (tmpFile.isFile() && tmpFile.canRead()) {
                fileFound.set(tmpFile.getAbsolutePath());
            } else {
                URL url = ConfigurationManagerServiceMock.class.getClassLoader().getResource((String)path);
                if (url != null) {
                    fileFound.set(path);
                }
            }
        });
        LOG.info("Config file find. path: {}", fileFound.get());
        return (String)fileFound.get();
    }

    public Optional<ConfigData<JSONObject>> getConfigData(String configName) {
        return Optional.empty();
    }

    public Set<String> getConfigNames() {
        return new HashSet<String>();
    }

    public void unregisterSchema(String configName) {
    }

    public Set<String> getConfigIds(String configName) {
        Map<String, String> configs = this.configStore.get(configName);
        if (configs != null) {
            return configs.keySet();
        }
        return new HashSet<String>();
    }
}

