/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;

public enum AddressType {
    UNKNOWN(0),
    IP_V4(1),
    IP_V6(2);

    public final int value;

    private AddressType(int value) {
        this.value = value;
    }

    public static AddressType from(ByteBuf buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuf)buffer);
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return IP_V4;
            }
            case 2: {
                return IP_V6;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }
}

