/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.measurement.remote;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.opennms.netmgt.jasper.helper.MeasurementsHelper;
import org.opennms.netmgt.jasper.measurement.EmptyJRDataSource;
import org.opennms.netmgt.jasper.measurement.MeasurementDataSource;
import org.opennms.netmgt.jasper.measurement.MeasurementDataSourceWrapper;
import org.opennms.netmgt.jasper.measurement.remote.MeasurementApiClient;
import org.opennms.netmgt.jasper.measurement.remote.Result;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMeasurementDataSourceWrapper
implements MeasurementDataSourceWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteMeasurementDataSourceWrapper.class);
    private final MeasurementApiClient connector = new MeasurementApiClient();
    private final String url;
    private final String username;
    private final String password;
    private final boolean useSsl;

    public RemoteMeasurementDataSourceWrapper(boolean useSsl, String url, String username, String password) {
        this.username = username;
        this.password = password;
        this.url = url;
        this.useSsl = useSsl;
    }

    @Override
    public JRRewindableDataSource createDataSource(String query) throws JRException {
        try {
            QueryRequest queryRequest = MeasurementsHelper.unmarshal(query);
            queryRequest.setRelaxed(true);
            query = MeasurementsHelper.marshal(queryRequest);
            Result result = this.connector.execute(this.useSsl, this.url, this.username, this.password, query);
            if (result.wasRedirection()) {
                throw new IOException("Request was redirected. This is not supported.");
            }
            if (404 == result.getResponseCode()) {
                LOG.warn("Got a 404 (Not Found) response. This might be due to a wrong url or the resource does not exist. Requested URL was: '{}'", (Object)this.url);
                return new EmptyJRDataSource();
            }
            if (result.wasSuccessful() && result.getInputStream() != null) {
                return new MeasurementDataSource(result.getInputStream());
            }
            ByteArrayOutputStream errorMessageStream = new ByteArrayOutputStream();
            if (result.getErrorStream() != null) {
                ByteStreams.copy(result.getErrorStream(), errorMessageStream);
            }
            throw new JRException("Invalid request. Response was : " + result.getResponseCode() + " (" + result.getResponseMessage() + ")\n" + errorMessageStream.toString());
        }
        catch (IOException ioException) {
            throw new JRException((Throwable)ioException);
        }
    }

    @Override
    public void close() {
        if (this.connector != null) {
            this.connector.disconnect();
        }
    }
}

