/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.one.profiler;

import io.pyroscope.one.profiler.AsyncProfilerMXBean;
import io.pyroscope.one.profiler.Counter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class AsyncProfiler
implements AsyncProfilerMXBean {
    private static AsyncProfiler instance;

    private AsyncProfiler() {
    }

    public static AsyncProfiler getInstance() {
        return AsyncProfiler.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized AsyncProfiler getInstance(String string) {
        if (instance != null) {
            return instance;
        }
        AsyncProfiler asyncProfiler = new AsyncProfiler();
        if (string != null) {
            System.load(string);
        } else {
            try {
                asyncProfiler.getVersion();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                File file = AsyncProfiler.extractEmbeddedLib();
                if (file != null) {
                    try {
                        System.load(file.getPath());
                    }
                    finally {
                        file.delete();
                    }
                }
                System.loadLibrary("asyncProfiler");
            }
        }
        instance = asyncProfiler;
        return asyncProfiler;
    }

    private static File extractEmbeddedLib() {
        String string = "/" + AsyncProfiler.getPlatformTag() + "/libasyncProfiler.so";
        InputStream inputStream2 = AsyncProfiler.class.getResourceAsStream(string);
        if (inputStream2 == null) {
            return null;
        }
        try {
            String string2 = System.getProperty("io.pyroscope.one.profiler.extractPath");
            File file = File.createTempFile("libasyncProfiler-", ".so", string2 == null || string2.isEmpty() ? null : new File(string2));
            try (Object object = new FileOutputStream(file);){
                int n;
                byte[] byArray = new byte[32000];
                while ((n = inputStream2.read(byArray)) >= 0) {
                    ((FileOutputStream)object).write(byArray, 0, n);
                }
            }
            object = file;
            return object;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        finally {
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String getPlatformTag() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        if (string.contains("linux")) {
            if (string2.equals("amd64") || string2.equals("x86_64") || string2.contains("x64")) {
                return "linux-x64";
            }
            if (string2.equals("aarch64") || string2.contains("arm64")) {
                return "linux-arm64";
            }
            if (string2.equals("aarch32") || string2.contains("arm")) {
                return "linux-arm32";
            }
            if (string2.contains("86")) {
                return "linux-x86";
            }
            if (string2.contains("ppc64")) {
                return "linux-ppc64le";
            }
        } else if (string.contains("mac")) {
            return "macos";
        }
        throw new UnsupportedOperationException("Unsupported platform: " + string + "-" + string2);
    }

    @Override
    public void start(String string, long l) throws IllegalStateException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.start0(string, l, true);
    }

    @Override
    public void resume(String string, long l) throws IllegalStateException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.start0(string, l, false);
    }

    @Override
    public void stop() throws IllegalStateException {
        this.stop0();
    }

    @Override
    public native long getSamples();

    @Override
    public String getVersion() {
        try {
            return this.execute0("version");
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public String execute(String string) throws IllegalArgumentException, IllegalStateException, IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        return this.execute0(string);
    }

    @Override
    public String dumpCollapsed(Counter counter) {
        try {
            return this.execute0("collapsed," + counter.name().toLowerCase());
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public String dumpTraces(int n) {
        try {
            return this.execute0(n == 0 ? "traces" : "traces=" + n);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public String dumpFlat(int n) {
        try {
            return this.execute0(n == 0 ? "flat" : "flat=" + n);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public void addThread(Thread thread) {
        this.filterThread(thread, true);
    }

    public void removeThread(Thread thread) {
        this.filterThread(thread, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterThread(Thread thread, boolean bl) {
        if (thread == null || thread == Thread.currentThread()) {
            this.filterThread0(null, bl);
        } else {
            Thread thread2 = thread;
            synchronized (thread2) {
                Thread.State state = thread.getState();
                if (state != Thread.State.NEW && state != Thread.State.TERMINATED) {
                    this.filterThread0(thread, bl);
                }
            }
        }
    }

    public void setContextId(long l) {
        this.setContextId0(l);
    }

    public void clearContextId() {
        this.setContextId0(0L);
    }

    private native void start0(String var1, long var2, boolean var4) throws IllegalStateException;

    private native void stop0() throws IllegalStateException;

    private native String execute0(String var1) throws IllegalArgumentException, IllegalStateException, IOException;

    private native void filterThread0(Thread var1, boolean var2);

    private native void setContextId0(long var1);
}

