/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.config;

import io.pyroscope.com.squareup.moshi.JsonAdapter;
import io.pyroscope.com.squareup.moshi.Moshi;
import io.pyroscope.com.squareup.moshi.Types;
import io.pyroscope.http.Format;
import io.pyroscope.javaagent.EventType;
import io.pyroscope.javaagent.api.ConfigurationProvider;
import io.pyroscope.javaagent.api.Logger;
import io.pyroscope.javaagent.config.AppName;
import io.pyroscope.javaagent.config.IntervalParser;
import io.pyroscope.javaagent.impl.DefaultConfigurationProvider;
import io.pyroscope.javaagent.impl.DefaultLogger;
import io.pyroscope.okhttp3.HttpUrl;
import io.pyroscope.org.jetbrains.annotations.NotNull;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Config {
    private static final String PYROSCOPE_AGENT_ENABLED_CONFIG = "PYROSCOPE_AGENT_ENABLED";
    private static final String PYROSCOPE_APPLICATION_NAME_CONFIG = "PYROSCOPE_APPLICATION_NAME";
    private static final String PYROSCOPE_PROFILING_INTERVAL_CONFIG = "PYROSCOPE_PROFILING_INTERVAL";
    private static final String PYROSCOPE_PROFILER_EVENT_CONFIG = "PYROSCOPE_PROFILER_EVENT";
    private static final String PYROSCOPE_PROFILER_ALLOC_CONFIG = "PYROSCOPE_PROFILER_ALLOC";
    private static final String PYROSCOPE_PROFILER_LOCK_CONFIG = "PYROSCOPE_PROFILER_LOCK";
    private static final String PYROSCOPE_UPLOAD_INTERVAL_CONFIG = "PYROSCOPE_UPLOAD_INTERVAL";
    private static final String PYROSCOPE_JAVA_STACK_DEPTH_MAX = "PYROSCOPE_JAVA_STACK_DEPTH_MAX";
    private static final String PYROSCOPE_LOG_LEVEL_CONFIG = "PYROSCOPE_LOG_LEVEL";
    private static final String PYROSCOPE_AP_LOG_LEVEL_CONFIG = "PYROSCOPE_AP_LOG_LEVEL";
    private static final String PYROSCOPE_AP_EXTRA_ARGUMENTS_CONFIG = "PYROSCOPE_AP_EXTRA_ARGUMENTS";
    private static final String PYROSCOPE_SERVER_ADDRESS_CONFIG = "PYROSCOPE_SERVER_ADDRESS";
    private static final String PYROSCOPE_ADHOC_SERVER_ADDRESS_CONFIG = "PYROSCOPE_ADHOC_SERVER_ADDRESS";
    private static final String PYROSCOPE_AUTH_TOKEN_CONFIG = "PYROSCOPE_AUTH_TOKEN";
    private static final String PYROSCOPE_BASIC_AUTH_USER_CONFIG = "PYROSCOPE_BASIC_AUTH_USER";
    private static final String PYROSCOPE_BASIC_AUTH_PASSWORD_CONFIG = "PYROSCOPE_BASIC_AUTH_PASSWORD";
    private static final String PYROSCOPE_FORMAT_CONFIG = "PYROSCOPE_FORMAT";
    private static final String PYROSCOPE_PUSH_QUEUE_CAPACITY_CONFIG = "PYROSCOPE_PUSH_QUEUE_CAPACITY";
    private static final String PYROSCOPE_LABELS = "PYROSCOPE_LABELS";
    private static final String PYROSCOPE_INGEST_MAX_TRIES = "PYROSCOPE_INGEST_MAX_TRIES";
    private static final String PYROSCOPE_EXPORT_COMPRESSION_LEVEL_JFR = "PYROSCOPE_EXPORT_COMPRESSION_LEVEL_JFR";
    private static final String PYROSCOPE_EXPORT_COMPRESSION_LEVEL_LABELS = "PYROSCOPE_EXPORT_COMPRESSION_LEVEL_LABELS";
    private static final String PYROSCOPE_ALLOC_LIVE = "PYROSCOPE_ALLOC_LIVE";
    private static final String PYROSCOPE_GC_BEFORE_DUMP = "PYROSCOPE_GC_BEFORE_DUMP";
    private static final String PYROSCOPE_HTTP_HEADERS = "PYROSCOPE_HTTP_HEADERS";
    private static final String PYROSCOPE_TENANT_ID = "PYROSCOPE_TENANT_ID";
    private static final String PYROSCOPE_SAMPLING_RATE = "PYROSCOPE_SAMPLING_RATE";
    private static final String PYROSCOPE_SAMPLING_DURATION = "PYROSCOPE_SAMPLING_DURATION";
    private static final String PYROSCOPE_SAMPLING_EVENT_ORDER_CONFIG = "PYROSCOPE_SAMPLING_EVENT_ORDER";
    private static final boolean DEFAULT_AGENT_ENABLED = true;
    public static final String DEFAULT_SPY_NAME = "javaspy";
    private static final Duration DEFAULT_PROFILING_INTERVAL = Duration.ofMillis(10L);
    private static final EventType DEFAULT_PROFILER_EVENT = EventType.ITIMER;
    private static final String DEFAULT_PROFILER_ALLOC = "";
    private static final String DEFAULT_PROFILER_LOCK = "";
    private static final Duration DEFAULT_UPLOAD_INTERVAL = Duration.ofSeconds(10L);
    private static final List<EventType> DEFAULT_SAMPLING_EVENT_ORDER = null;
    private static final int DEFAULT_JAVA_STACK_DEPTH_MAX = 2048;
    private static final String DEFAULT_SERVER_ADDRESS = "http://localhost:4040";
    private static final Format DEFAULT_FORMAT = Format.JFR;
    private static final int DEFAULT_PUSH_QUEUE_CAPACITY = 8;
    private static final int DEFAULT_INGEST_MAX_RETRIES = 8;
    private static final int DEFAULT_COMPRESSION_LEVEL = 1;
    private static final String DEFAULT_LABELS = "";
    private static final boolean DEFAULT_ALLOC_LIVE = false;
    private static final boolean DEFAULT_GC_BEFORE_DUMP = false;
    private static final Duration DEFAULT_SAMPLING_DURATION = null;
    public final boolean agentEnabled;
    public final String applicationName;
    public final Duration profilingInterval;
    public final EventType profilingEvent;
    public final String profilingAlloc;
    public final String profilingLock;
    public final List<EventType> samplingEventOrder;
    public final Duration uploadInterval;
    public final int javaStackDepthMax;
    public final Logger.Level logLevel;
    public final String serverAddress;
    public final String authToken;
    @Deprecated
    public final String timeseriesName;
    public final AppName timeseries;
    public final Format format;
    public final int pushQueueCapacity;
    public final Map<String, String> labels;
    public final int ingestMaxTries;
    public final int compressionLevelJFR;
    public final int compressionLevelLabels;
    public final boolean allocLive;
    public final boolean gcBeforeDump;
    public final Map<String, String> httpHeaders;
    public final Duration samplingDuration;
    public final String tenantID;
    public final String APLogLevel;
    public final String APExtraArguments;
    public final String basicAuthUser;
    public final String basicAuthPassword;

    Config(boolean agentEnabled, String applicationName, Duration profilingInterval, EventType profilingEvent, String profilingAlloc, String profilingLock, List<EventType> samplingEventOrder, Duration uploadInterval, int javaStackDepthMax, Logger.Level logLevel, String serverAddress, String authToken, Format format, int pushQueueCapacity, Map<String, String> labels, int ingestMaxRetries, int compressionLevelJFR, int compressionLevelLabels, boolean allocLive, boolean gcBeforeDump, Map<String, String> httpHeaders, Duration samplingDuration, String tenantID, String APLogLevel, String APExtraArguments, String basicAuthUser, String basicAuthPassword) {
        this.agentEnabled = agentEnabled;
        this.applicationName = applicationName;
        this.profilingInterval = profilingInterval;
        this.profilingEvent = profilingEvent;
        this.profilingAlloc = profilingAlloc;
        this.profilingLock = profilingLock;
        this.uploadInterval = uploadInterval;
        this.javaStackDepthMax = javaStackDepthMax;
        this.logLevel = logLevel;
        this.serverAddress = serverAddress;
        this.authToken = authToken;
        this.ingestMaxTries = ingestMaxRetries;
        this.compressionLevelJFR = Config.validateCompressionLevel(compressionLevelJFR);
        this.compressionLevelLabels = Config.validateCompressionLevel(compressionLevelLabels);
        this.allocLive = allocLive;
        this.gcBeforeDump = gcBeforeDump;
        this.httpHeaders = httpHeaders;
        this.samplingDuration = samplingDuration;
        this.tenantID = tenantID;
        this.APLogLevel = APLogLevel;
        this.APExtraArguments = APExtraArguments;
        this.basicAuthUser = basicAuthUser;
        this.basicAuthPassword = basicAuthPassword;
        this.timeseries = this.timeseriesName(AppName.parse(applicationName), profilingEvent, format);
        this.timeseriesName = this.timeseries.toString();
        this.format = format;
        this.pushQueueCapacity = pushQueueCapacity;
        this.labels = Collections.unmodifiableMap(labels);
        HttpUrl serverAddressUrl = HttpUrl.parse(serverAddress);
        if (serverAddressUrl == null) {
            throw new IllegalArgumentException("invalid url " + serverAddress);
        }
        if (authToken != null && basicAuthUser != null) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "auth token is ignored (both auth token and basic auth specified)", new Object[0]);
        }
        this.samplingEventOrder = Config.resolve(samplingEventOrder, profilingEvent, profilingAlloc, profilingLock, this.samplingDuration);
        if ("0".equals(this.profilingAlloc)) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Setting PYROSCOPE_PROFILER_ALLOC to 0 registers every allocation event, causing significant overhead and results in large profiles, making it not ideal for production. We recommend a starting value of 512k, adjusting as needed.", new Object[0]);
        }
        if ("0".equals(this.profilingLock)) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Setting PYROSCOPE_PROFILER_LOCK to 0 registers every lock event, causing significant overhead and results in large profiles, making it not ideal for production. We recommend a starting value of 10ms, adjusting as needed.", new Object[0]);
        }
    }

    public long profilingIntervalInHertz() {
        return Config.durationToHertz(this.profilingInterval);
    }

    public String toString() {
        return "Config{agentEnabled=" + this.agentEnabled + ", applicationName='" + this.applicationName + '\'' + ", profilingInterval=" + this.profilingInterval + ", profilingEvent=" + (Object)((Object)this.profilingEvent) + ", profilingAlloc='" + this.profilingAlloc + '\'' + ", profilingLock='" + this.profilingLock + '\'' + ", samplingEventOrder='" + this.samplingEventOrder + '\'' + ", uploadInterval=" + this.uploadInterval + ", javaStackDepthMax=" + this.javaStackDepthMax + ", logLevel=" + (Object)((Object)this.logLevel) + ", serverAddress='" + this.serverAddress + '\'' + ", authToken='" + this.authToken + '\'' + ", timeseriesName='" + this.timeseriesName + '\'' + ", timeseries=" + this.timeseries + ", format=" + (Object)((Object)this.format) + ", pushQueueCapacity=" + this.pushQueueCapacity + ", labels=" + this.labels + ", ingestMaxTries=" + this.ingestMaxTries + ", compressionLevelJFR=" + this.compressionLevelJFR + ", compressionLevelLabels=" + this.compressionLevelLabels + ", allocLive=" + this.allocLive + ", httpHeaders=" + this.httpHeaders + ", samplingDuration=" + this.samplingDuration + ", tenantID=" + this.tenantID + '}';
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    private static long durationToHertz(Duration duration) {
        Duration oneSecond = Duration.ofSeconds(1L);
        return oneSecond.toNanos() / duration.toNanos();
    }

    public static Config build() {
        return Config.build(DefaultConfigurationProvider.INSTANCE);
    }

    public static Config build(ConfigurationProvider cp) {
        String alloc = Config.profilingAlloc(cp);
        boolean agentEnabled = Config.bool(cp, PYROSCOPE_AGENT_ENABLED_CONFIG, true);
        boolean allocLive = Config.bool(cp, PYROSCOPE_ALLOC_LIVE, false);
        if ("".equals(alloc) && allocLive) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "%s is ignored because %s is not configured", PYROSCOPE_ALLOC_LIVE, PYROSCOPE_PROFILER_ALLOC_CONFIG);
            allocLive = false;
        }
        return new Config(agentEnabled, Config.applicationName(cp), Config.profilingInterval(cp), Config.profilingEvent(cp), alloc, Config.profilingLock(cp), Config.samplingEventOrder(cp), Config.uploadInterval(cp), Config.javaStackDepthMax(cp), Config.logLevel(cp), Config.serverAddress(cp), Config.authToken(cp), Config.format(cp), Config.pushQueueCapacity(cp), Config.labels(cp), Config.ingestMaxRetries(cp), Config.compressionLevel(cp, PYROSCOPE_EXPORT_COMPRESSION_LEVEL_JFR), Config.compressionLevel(cp, PYROSCOPE_EXPORT_COMPRESSION_LEVEL_LABELS), allocLive, Config.bool(cp, PYROSCOPE_GC_BEFORE_DUMP, false), Config.httpHeaders(cp), Config.samplingDuration(cp), Config.tenantID(cp), cp.get(PYROSCOPE_AP_LOG_LEVEL_CONFIG), cp.get(PYROSCOPE_AP_EXTRA_ARGUMENTS_CONFIG), cp.get(PYROSCOPE_BASIC_AUTH_USER_CONFIG), cp.get(PYROSCOPE_BASIC_AUTH_PASSWORD_CONFIG));
    }

    private static String applicationName(ConfigurationProvider configurationProvider) {
        String applicationName = configurationProvider.get(PYROSCOPE_APPLICATION_NAME_CONFIG);
        if (applicationName == null || applicationName.isEmpty()) {
            applicationName = Config.generateApplicationName();
        }
        return applicationName;
    }

    @NotNull
    private static String generateApplicationName() {
        DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.INFO, "We recommend specifying application name via env variable %s", PYROSCOPE_APPLICATION_NAME_CONFIG);
        UUID uuid = UUID.randomUUID();
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        String random = Base64.getUrlEncoder().withoutPadding().encodeToString(byteBuffer.array());
        String applicationName = "javaspy." + random;
        DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.INFO, "For now we chose the name for you and it's %s", applicationName);
        return applicationName;
    }

    private static Duration profilingInterval(ConfigurationProvider configurationProvider) {
        String profilingIntervalStr = configurationProvider.get(PYROSCOPE_PROFILING_INTERVAL_CONFIG);
        if (profilingIntervalStr == null || profilingIntervalStr.isEmpty()) {
            return DEFAULT_PROFILING_INTERVAL;
        }
        try {
            return IntervalParser.parse(profilingIntervalStr);
        }
        catch (NumberFormatException e) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Invalid %s value %s, using %sms", PYROSCOPE_PROFILING_INTERVAL_CONFIG, profilingIntervalStr, DEFAULT_PROFILING_INTERVAL.toMillis());
            return DEFAULT_PROFILING_INTERVAL;
        }
    }

    private AppName timeseriesName(AppName app, EventType eventType, Format format) {
        if (format == Format.JFR) {
            return app;
        }
        return app.newBuilder().setName(app.name + "." + eventType.id).build();
    }

    private static EventType profilingEvent(ConfigurationProvider configurationProvider) {
        String profilingEventStr = configurationProvider.get(PYROSCOPE_PROFILER_EVENT_CONFIG);
        if (profilingEventStr == null || profilingEventStr.isEmpty()) {
            return DEFAULT_PROFILER_EVENT;
        }
        String lowerCaseTrimmed = profilingEventStr.trim().toLowerCase();
        try {
            return EventType.fromId(lowerCaseTrimmed);
        }
        catch (IllegalArgumentException e) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Invalid %s value %s, using %s", PYROSCOPE_PROFILER_EVENT_CONFIG, profilingEventStr, Config.DEFAULT_PROFILER_EVENT.id);
            return DEFAULT_PROFILER_EVENT;
        }
    }

    private static String profilingAlloc(ConfigurationProvider configurationProvider) {
        String profilingAlloc = configurationProvider.get(PYROSCOPE_PROFILER_ALLOC_CONFIG);
        if (profilingAlloc == null || profilingAlloc.isEmpty()) {
            return "";
        }
        return profilingAlloc.trim().toLowerCase();
    }

    private static String profilingLock(ConfigurationProvider configurationProvider) {
        String profilingLock = configurationProvider.get(PYROSCOPE_PROFILER_LOCK_CONFIG);
        if (profilingLock == null || profilingLock.isEmpty()) {
            return "";
        }
        return profilingLock.trim().toLowerCase();
    }

    private static List<EventType> samplingEventOrder(ConfigurationProvider cp) {
        String samplingEventOrder = cp.get(PYROSCOPE_SAMPLING_EVENT_ORDER_CONFIG);
        if (null == samplingEventOrder || samplingEventOrder.isEmpty()) {
            return DEFAULT_SAMPLING_EVENT_ORDER;
        }
        DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "keep upload interval >= sampling duration * distinct event count to avoid unexpected behaviour", new Object[0]);
        return Stream.of(samplingEventOrder.split("\\s*,\\s*")).map(s -> {
            try {
                return EventType.fromId(s);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(t -> null != t).collect(Collectors.toCollection(() -> new ArrayList()));
    }

    private static List<EventType> resolve(List<EventType> samplingEventOrder, EventType type, String alloc, String lock, Duration samplingDuration) {
        if (null == samplingEventOrder) {
            return null;
        }
        if (null == samplingDuration) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "not implemented: sampling event order is only implemented in sampling mode", new Object[0]);
            return null;
        }
        LinkedHashSet<EventType> set = new LinkedHashSet<EventType>();
        boolean _alloc = null != alloc && !alloc.isEmpty();
        boolean _lock = null != lock && !lock.isEmpty();
        for (EventType t : samplingEventOrder) {
            if (!t.equals((Object)type) && (!EventType.ALLOC.equals((Object)t) || !_alloc) && (!EventType.LOCK.equals((Object)t) || !_lock)) continue;
            set.add(t);
        }
        set.add(type);
        if (_alloc) {
            set.add(EventType.ALLOC);
        }
        if (_lock) {
            set.add(EventType.LOCK);
        }
        return new ArrayList<EventType>(set);
    }

    private static Duration uploadInterval(ConfigurationProvider configurationProvider) {
        String uploadIntervalStr = configurationProvider.get(PYROSCOPE_UPLOAD_INTERVAL_CONFIG);
        if (uploadIntervalStr == null || uploadIntervalStr.isEmpty()) {
            return DEFAULT_UPLOAD_INTERVAL;
        }
        try {
            return IntervalParser.parse(uploadIntervalStr);
        }
        catch (NumberFormatException e) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Invalid %s value %s, using %s", PYROSCOPE_UPLOAD_INTERVAL_CONFIG, uploadIntervalStr, DEFAULT_UPLOAD_INTERVAL);
            return DEFAULT_UPLOAD_INTERVAL;
        }
    }

    private static int javaStackDepthMax(ConfigurationProvider configurationProvider) {
        String javaStackDepthMaxStr = configurationProvider.get(PYROSCOPE_JAVA_STACK_DEPTH_MAX);
        if (null == javaStackDepthMaxStr || javaStackDepthMaxStr.isEmpty()) {
            return 2048;
        }
        try {
            return Integer.parseInt(javaStackDepthMaxStr);
        }
        catch (NumberFormatException e) {
            return 2048;
        }
    }

    private static Logger.Level logLevel(ConfigurationProvider configurationProvider) {
        String logLevel = configurationProvider.get(PYROSCOPE_LOG_LEVEL_CONFIG);
        if (logLevel == null || logLevel.isEmpty()) {
            return Logger.Level.INFO;
        }
        switch (logLevel.toLowerCase(Locale.ROOT)) {
            case "debug": {
                return Logger.Level.DEBUG;
            }
            case "info": {
                return Logger.Level.INFO;
            }
            case "warn": {
                return Logger.Level.WARN;
            }
            case "error": {
                return Logger.Level.ERROR;
            }
        }
        DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Unknown log level %s, using INFO", logLevel);
        return Logger.Level.INFO;
    }

    private static String serverAddress(ConfigurationProvider configurationProvider) {
        String serverAddress = configurationProvider.get(PYROSCOPE_ADHOC_SERVER_ADDRESS_CONFIG);
        if (serverAddress == null || serverAddress.isEmpty()) {
            serverAddress = configurationProvider.get(PYROSCOPE_SERVER_ADDRESS_CONFIG);
        }
        if (serverAddress == null || serverAddress.isEmpty()) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "%s is not defined, using %s", PYROSCOPE_SERVER_ADDRESS_CONFIG, DEFAULT_SERVER_ADDRESS);
            serverAddress = DEFAULT_SERVER_ADDRESS;
        }
        return serverAddress;
    }

    private static String authToken(ConfigurationProvider configurationProvider) {
        return configurationProvider.get(PYROSCOPE_AUTH_TOKEN_CONFIG);
    }

    private static Format format(ConfigurationProvider configurationProvider) {
        String format = configurationProvider.get(PYROSCOPE_FORMAT_CONFIG);
        if (format == null || format.isEmpty()) {
            return DEFAULT_FORMAT;
        }
        switch (format.trim().toLowerCase()) {
            case "jfr": {
                return Format.JFR;
            }
        }
        DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Unknown format %s, using %s", new Object[]{format, DEFAULT_FORMAT});
        return DEFAULT_FORMAT;
    }

    private static int pushQueueCapacity(ConfigurationProvider configurationProvider) {
        String strPushQueueCapacity = configurationProvider.get(PYROSCOPE_PUSH_QUEUE_CAPACITY_CONFIG);
        if (strPushQueueCapacity == null || strPushQueueCapacity.isEmpty()) {
            return 8;
        }
        try {
            int pushQueueCapacity = Integer.parseInt(strPushQueueCapacity);
            if (pushQueueCapacity <= 0) {
                return 8;
            }
            return pushQueueCapacity;
        }
        catch (NumberFormatException e) {
            return 8;
        }
    }

    public static Map<String, String> labels(ConfigurationProvider configurationProvider) {
        String strLabels = configurationProvider.get(PYROSCOPE_LABELS);
        if (strLabels == null) {
            strLabels = "";
        }
        return AppName.parseLabels(strLabels);
    }

    private static int ingestMaxRetries(ConfigurationProvider configurationProvider) {
        String strIngestMaxRetries = configurationProvider.get(PYROSCOPE_INGEST_MAX_TRIES);
        if (strIngestMaxRetries == null || strIngestMaxRetries.isEmpty()) {
            return 8;
        }
        try {
            return Integer.parseInt(strIngestMaxRetries);
        }
        catch (NumberFormatException e) {
            return 8;
        }
    }

    public static boolean bool(ConfigurationProvider cp, String key, boolean defaultValue) {
        String v = cp.get(key);
        if (v == null || v.isEmpty()) {
            return defaultValue;
        }
        return Boolean.parseBoolean(v);
    }

    public static int compressionLevel(ConfigurationProvider cp, String key) {
        int level;
        String sLevel = cp.get(key);
        if (sLevel == null || sLevel.isEmpty()) {
            return 1;
        }
        if ("NO_COMPRESSION".equalsIgnoreCase(sLevel)) {
            return 0;
        }
        if ("BEST_SPEED".equalsIgnoreCase(sLevel)) {
            return 1;
        }
        if ("BEST_COMPRESSION".equalsIgnoreCase(sLevel)) {
            return 9;
        }
        if ("DEFAULT_COMPRESSION".equalsIgnoreCase(sLevel)) {
            return -1;
        }
        try {
            level = Integer.parseInt(sLevel);
        }
        catch (NumberFormatException e) {
            return 1;
        }
        if (level >= 0 && level <= 9 || level == -1) {
            return level;
        }
        return 1;
    }

    private static int validateCompressionLevel(int level) {
        if (level >= -1 && level <= 9) {
            return level;
        }
        throw new IllegalArgumentException(String.format("wrong deflate compression level %d", level));
    }

    public static Map<String, String> httpHeaders(ConfigurationProvider cp) {
        String sHttpHeaders = cp.get(PYROSCOPE_HTTP_HEADERS);
        if (sHttpHeaders == null || sHttpHeaders.isEmpty()) {
            return Collections.emptyMap();
        }
        Moshi moshi = new Moshi.Builder().build();
        ParameterizedType headersType = Types.newParameterizedType(Map.class, new Type[]{String.class, String.class});
        JsonAdapter adapter = moshi.adapter(headersType);
        try {
            Map httpHeaders = (Map)adapter.fromJson(sHttpHeaders);
            if (httpHeaders == null) {
                return Collections.emptyMap();
            }
            return httpHeaders;
        }
        catch (Exception e) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.ERROR, "Failed to parse %s = %s configuration. Falling back to no extra http headers. %s: ", PYROSCOPE_HTTP_HEADERS, sHttpHeaders, e.getMessage());
            return Collections.emptyMap();
        }
    }

    private static String tenantID(ConfigurationProvider cp) {
        return cp.get(PYROSCOPE_TENANT_ID);
    }

    private static Duration samplingDuration(ConfigurationProvider configurationProvider) {
        Duration uploadInterval = Config.uploadInterval(configurationProvider);
        String samplingDurationStr = configurationProvider.get(PYROSCOPE_SAMPLING_DURATION);
        if (samplingDurationStr != null && !samplingDurationStr.isEmpty()) {
            try {
                Duration samplingDuration = IntervalParser.parse(samplingDurationStr);
                if (samplingDuration.compareTo(uploadInterval) <= 0) {
                    return samplingDuration;
                }
                DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Invalid %s value %s, ignore it", PYROSCOPE_SAMPLING_DURATION, samplingDurationStr);
            }
            catch (NumberFormatException e) {
                DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Invalid %s value %s, ignore it", PYROSCOPE_SAMPLING_DURATION, samplingDurationStr);
            }
            return DEFAULT_SAMPLING_DURATION;
        }
        String samplingRateStr = configurationProvider.get(PYROSCOPE_SAMPLING_RATE);
        if (samplingRateStr == null || samplingRateStr.isEmpty()) {
            return DEFAULT_SAMPLING_DURATION;
        }
        try {
            double samplingRate = Double.parseDouble(samplingRateStr);
            if (samplingRate <= 0.0 || samplingRate >= 1.0) {
                return DEFAULT_SAMPLING_DURATION;
            }
            long uploadIntervalMillis = uploadInterval.toMillis();
            long samplingDurationMillis = Math.min(uploadIntervalMillis, Math.round((double)uploadIntervalMillis * samplingRate));
            return Duration.ofMillis(samplingDurationMillis);
        }
        catch (NumberFormatException e) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Invalid %s value %s, ignore it", PYROSCOPE_SAMPLING_RATE, samplingRateStr);
            return DEFAULT_SAMPLING_DURATION;
        }
    }

    static /* synthetic */ Duration access$000() {
        return DEFAULT_PROFILING_INTERVAL;
    }

    static /* synthetic */ EventType access$100() {
        return DEFAULT_PROFILER_EVENT;
    }

    static /* synthetic */ Duration access$200() {
        return DEFAULT_UPLOAD_INTERVAL;
    }

    static /* synthetic */ Format access$300() {
        return DEFAULT_FORMAT;
    }

    static /* synthetic */ Duration access$400() {
        return DEFAULT_SAMPLING_DURATION;
    }

    public static class Builder {
        public boolean agentEnabled = true;
        public String applicationName = null;
        public Duration profilingInterval = Config.access$000();
        public EventType profilingEvent = Config.access$100();
        public String profilingAlloc = "";
        public String profilingLock = "";
        public List<EventType> samplingEventOrder = null;
        public Duration uploadInterval = Config.access$200();
        public int javaStackDepthMax = 2048;
        public Logger.Level logLevel = Logger.Level.INFO;
        public String serverAddress = "http://localhost:4040";
        public String authToken = null;
        public Format format = Config.access$300();
        public int pushQueueCapacity = 8;
        public Map<String, String> labels = Collections.emptyMap();
        public int ingestMaxRetries = 8;
        public int compressionLevelJFR = 1;
        public int compressionLevelLabels = 1;
        public boolean allocLive = false;
        public boolean gcBeforeDump = false;
        public Map<String, String> httpHeaders = new HashMap<String, String>();
        public Duration samplingDuration = Config.access$400();
        private String tenantID = null;
        private String APLogLevel = null;
        private String APExtraArguments = null;
        private String basicAuthUser;
        private String basicAuthPassword;

        public Builder() {
        }

        public Builder(Config buildUpon) {
            this.agentEnabled = buildUpon.agentEnabled;
            this.applicationName = buildUpon.applicationName;
            this.profilingInterval = buildUpon.profilingInterval;
            this.profilingEvent = buildUpon.profilingEvent;
            this.profilingAlloc = buildUpon.profilingAlloc;
            this.profilingLock = buildUpon.profilingLock;
            this.samplingEventOrder = buildUpon.samplingEventOrder;
            this.uploadInterval = buildUpon.uploadInterval;
            this.javaStackDepthMax = buildUpon.javaStackDepthMax;
            this.logLevel = buildUpon.logLevel;
            this.serverAddress = buildUpon.serverAddress;
            this.authToken = buildUpon.authToken;
            this.format = buildUpon.format;
            this.pushQueueCapacity = buildUpon.pushQueueCapacity;
            this.compressionLevelJFR = buildUpon.compressionLevelJFR;
            this.compressionLevelLabels = buildUpon.compressionLevelLabels;
            this.allocLive = buildUpon.allocLive;
            this.gcBeforeDump = buildUpon.gcBeforeDump;
            this.httpHeaders = new HashMap<String, String>(buildUpon.httpHeaders);
            this.samplingDuration = buildUpon.samplingDuration;
            this.tenantID = buildUpon.tenantID;
            this.APLogLevel = buildUpon.APLogLevel;
            this.APExtraArguments = buildUpon.APExtraArguments;
            this.basicAuthUser = buildUpon.basicAuthUser;
            this.basicAuthPassword = buildUpon.basicAuthPassword;
        }

        public Builder setAgentEnabled(boolean agentEnabled) {
            this.agentEnabled = agentEnabled;
            return this;
        }

        public Builder setApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder setProfilingInterval(Duration profilingInterval) {
            this.profilingInterval = profilingInterval;
            return this;
        }

        public Builder setProfilingEvent(EventType profilingEvent) {
            this.profilingEvent = profilingEvent;
            return this;
        }

        public Builder setProfilingAlloc(String profilingAlloc) {
            this.profilingAlloc = profilingAlloc;
            return this;
        }

        public Builder setProfilingLock(String profilingLock) {
            this.profilingLock = profilingLock;
            return this;
        }

        public Builder setSamplingEventOrder(List<EventType> samplingEventOrder) {
            this.samplingEventOrder = samplingEventOrder;
            return this;
        }

        public Builder setUploadInterval(Duration uploadInterval) {
            this.uploadInterval = uploadInterval;
            return this;
        }

        public Builder setJavaStackDepthMax(int javaStackDepthMax) {
            this.javaStackDepthMax = javaStackDepthMax;
            return this;
        }

        public Builder setLogLevel(Logger.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder setServerAddress(String serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public Builder setAuthToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public Builder setFormat(Format format) {
            this.format = format;
            return this;
        }

        public Builder setPushQueueCapacity(int pushQueueCapacity) {
            this.pushQueueCapacity = pushQueueCapacity;
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder setIngestMaxRetries(int ingestMaxRetries) {
            this.ingestMaxRetries = ingestMaxRetries;
            return this;
        }

        public Builder setCompressionLevelJFR(int compressionLevelJFR) {
            this.compressionLevelJFR = Config.validateCompressionLevel(compressionLevelJFR);
            return this;
        }

        public Builder setCompressionLevelLabels(int compressionLevelLabels) {
            this.compressionLevelLabels = Config.validateCompressionLevel(compressionLevelLabels);
            return this;
        }

        public Builder setAllocLive(boolean allocLive) {
            this.allocLive = allocLive;
            return this;
        }

        public Builder setGcBeforeDump(boolean gcBeforeDump) {
            this.gcBeforeDump = gcBeforeDump;
            return this;
        }

        public Builder setHTTPHeaders(Map<String, String> httpHeaders) {
            this.httpHeaders = new HashMap<String, String>(httpHeaders);
            return this;
        }

        public Builder addHTTPHeader(String k, String v) {
            this.httpHeaders.put(k, v);
            return this;
        }

        public Builder setSamplingDuration(Duration samplingDuration) {
            this.samplingDuration = samplingDuration;
            return this;
        }

        public Builder setTenantID(String tenantID) {
            this.tenantID = tenantID;
            return this;
        }

        public Builder setAPLogLevel(String apLogLevel) {
            this.APLogLevel = apLogLevel;
            return this;
        }

        public Builder setAPExtraArguments(String APExtraArguments) {
            this.APExtraArguments = APExtraArguments;
            return this;
        }

        public Builder setBasicAuthUser(String basicAuthUser) {
            this.basicAuthUser = basicAuthUser;
            return this;
        }

        public Builder setBasicAuthPassword(String basicAuthPassword) {
            this.basicAuthPassword = basicAuthPassword;
            return this;
        }

        public Config build() {
            if (this.applicationName == null || this.applicationName.isEmpty()) {
                this.applicationName = Config.generateApplicationName();
            }
            return new Config(this.agentEnabled, this.applicationName, this.profilingInterval, this.profilingEvent, this.profilingAlloc, this.profilingLock, this.samplingEventOrder, this.uploadInterval, this.javaStackDepthMax, this.logLevel, this.serverAddress, this.authToken, this.format, this.pushQueueCapacity, this.labels, this.ingestMaxRetries, this.compressionLevelJFR, this.compressionLevelLabels, this.allocLive, this.gcBeforeDump, this.httpHeaders, this.samplingDuration, this.tenantID, this.APLogLevel, this.APExtraArguments, this.basicAuthUser, this.basicAuthPassword);
        }
    }
}

