/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.commands;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.echo.EchoRequest;
import org.opennms.core.rpc.echo.EchoRpcModule;

@Command(scope="opennms", name="stress-rpc", description="Generates RPC requests against the Echo module")
@Service
public class StressCommand
implements Action {
    @Reference
    private RpcClientFactory rpcClientFactory;
    @Option(name="-l", aliases={"--location"}, description="Location")
    String location = null;
    @Option(name="-s", aliases={"--system-id"}, description="System ID")
    String systemId = null;
    @Option(name="-t", aliases={"--ttl"}, description="Time to live (milliseconds)")
    Long ttlInMs;
    @Option(name="-d", aliases={"--delay"}, description="Response delay (milliseconds)")
    Long delay;
    @Option(name="-ms", aliases={"--message-size"}, description="Message size (number of charaters)")
    int messageSize = 1024;
    @Option(name="-f", aliases={"--throw-exception"}, description="Throw ")
    boolean shouldThrow = false;
    @Option(name="-c", aliases={"--count"}, description="Number of requests")
    int count = 1;

    public Object execute() throws Exception {
        RpcClient client = this.rpcClientFactory.getClient((RpcModule)EchoRpcModule.INSTANCE);
        MetricRegistry metrics = new MetricRegistry();
        Histogram responseTimes = metrics.histogram("response-times");
        Counter successes = metrics.counter("successes");
        Counter failures = metrics.counter("failures");
        System.out.printf("Executing %d requests.\n", this.count);
        CountDownLatch doneSignal = new CountDownLatch(this.count);
        long beforeExec = System.currentTimeMillis();
        for (int i = 0; i < this.count; ++i) {
            client.execute((RpcRequest)this.buildRequest(this.messageSize)).whenComplete((r, e) -> {
                if (e != null) {
                    failures.inc();
                } else {
                    responseTimes.update(System.currentTimeMillis() - r.getId());
                    successes.inc();
                }
                doneSignal.countDown();
            });
        }
        long afterExec = System.currentTimeMillis();
        System.out.printf("Waiting for responses.\n", new Object[0]);
        while (true) {
            block5: {
                try {
                    if (doneSignal.await(1L, TimeUnit.SECONDS)) {
                        System.out.printf("\nDone!\n", new Object[0]);
                    }
                    break block5;
                }
                catch (InterruptedException e2) {
                    System.out.println("\nInterrupted!");
                }
                break;
            }
            System.out.print(".");
            System.out.flush();
        }
        long afterResponse = System.currentTimeMillis();
        System.out.println();
        ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)metrics).convertRatesTo(TimeUnit.MILLISECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        reporter.report();
        reporter.close();
        System.out.printf("Total milliseconds elapsed: %d\n", afterResponse - beforeExec);
        System.out.printf("Milliseconds spent generating requests: %d\n", afterExec - beforeExec);
        System.out.printf("Milliseconds spent waiting for responses: %d\n", afterResponse - afterExec);
        return null;
    }

    private EchoRequest buildRequest(Integer messageSize) {
        EchoRequest request = new EchoRequest();
        request.setId(Long.valueOf(System.currentTimeMillis()));
        String message = Strings.repeat((String)"*", (int)messageSize);
        request.setBody(message);
        request.setLocation(this.location);
        request.setSystemId(this.systemId);
        request.setTimeToLiveMs(this.ttlInMs);
        request.setDelay(this.delay);
        request.shouldThrow(this.shouldThrow);
        return request;
    }
}

