/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.application;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.search.SearchContext;
import org.opennms.netmgt.graph.api.search.SearchCriteria;
import org.opennms.netmgt.graph.api.search.SearchProvider;
import org.opennms.netmgt.graph.api.search.SearchSuggestion;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.graph.domain.AbstractDomainVertex;
import org.opennms.netmgt.graph.provider.application.ApplicationVertex;
import org.opennms.netmgt.graph.provider.application.ApplicationVertexType;
import org.opennms.netmgt.model.OnmsApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationSearchProvider
implements SearchProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationSearchProvider.class);
    private final ApplicationDao applicationDao;

    public ApplicationSearchProvider(ApplicationDao applicationDao) {
        this.applicationDao = Objects.requireNonNull(applicationDao);
    }

    public boolean canSuggest(GraphService graphService, String namespace) {
        return "application".equals(namespace);
    }

    public List<SearchSuggestion> getSuggestions(SearchContext searchContext, String namespace, String input) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsApplication.class);
        builder.ilike("name", (Object)String.format("%%%s%%", input));
        builder.orderBy("name", true);
        builder.limit(Integer.valueOf(searchContext.getSuggestionsLimit()));
        Criteria dbQueryCriteria = builder.toCriteria();
        ArrayList<SearchSuggestion> suggestions = new ArrayList<SearchSuggestion>();
        for (OnmsApplication application : this.applicationDao.findMatching(dbQueryCriteria)) {
            SearchSuggestion suggestion = new SearchSuggestion(this.getProviderId(), OnmsApplication.class.getSimpleName(), Integer.toString(application.getId()), application.getName());
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    public List<GenericVertex> resolve(GraphService graphService, SearchCriteria searchCriteria) {
        String applicationIdString = searchCriteria.getCriteria();
        try {
            int applicationId = Integer.parseInt(applicationIdString);
            return this.getVerticesOfGraph(graphService, searchCriteria.getNamespace()).stream().map(ApplicationVertex::new).filter(v -> this.filter((ApplicationVertex)((Object)v), applicationId)).map(AbstractDomainVertex::asGenericVertex).collect(Collectors.toList());
        }
        catch (NumberFormatException ex) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot convert string '{}' to number: {}", new Object[]{applicationIdString, ex.getMessage(), ex});
            return Lists.newArrayList();
        }
    }

    private boolean filter(ApplicationVertex vertex, Integer applicationId) {
        if (vertex.getVertexType() == ApplicationVertexType.Application && vertex.getApplicationId() != null) {
            return Objects.equals(vertex.getApplicationId(), applicationId);
        }
        return false;
    }

    private List<GenericVertex> getVerticesOfGraph(GraphService graphService, String namespace) {
        List result;
        GenericGraph graph = graphService.getGraph(namespace);
        if (graph != null) {
            result = graph.getVertices();
        } else {
            LOG.warn("Could not find graph for namespace {}", (Object)namespace);
            result = Collections.emptyList();
        }
        return result;
    }
}

