/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.syslog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogDestination;

@XmlRootElement(name="syslog-northbounder-config")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SyslogNorthbounderConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="enabled", required=false, defaultValue="false")
    private Boolean m_enabled;
    @XmlElement(name="nagles-delay", required=false, defaultValue="1000")
    private Integer m_naglesDelay;
    @XmlElement(name="batch-size", required=false, defaultValue="100")
    private Integer m_batchSize;
    @XmlElement(name="queue-size", required=false, defaultValue="300000")
    private Integer m_queueSize;
    @XmlElement(name="message-format", required=false, defaultValue="ALARM ID:${alarmId} NODE:${nodeLabel} ${logMsg}")
    private String m_messageFormat;
    @XmlElement(name="date-format", required=false)
    private String m_dateFormat;
    @XmlElement(name="destination")
    private List<SyslogDestination> m_destinations = new ArrayList<SyslogDestination>();
    @XmlElement(name="uei", required=false)
    private List<String> m_ueis;

    public List<SyslogDestination> getDestinations() {
        return this.m_destinations;
    }

    public void setDestinations(List<SyslogDestination> destinations) {
        this.m_destinations = destinations;
    }

    public List<String> getUeis() {
        return this.m_ueis;
    }

    public void setUeis(List<String> ueis) {
        this.m_ueis = ueis;
    }

    public String getMessageFormat() {
        return this.m_messageFormat == null ? "ALARM ID:${alarmId} NODE:${nodeLabel} ${logMsg}" : this.m_messageFormat;
    }

    public void setMessageFormat(String messageFormat) {
        this.m_messageFormat = messageFormat;
    }

    public String getDateFormat() {
        return this.m_dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.m_dateFormat = dateFormat;
    }

    public Integer getNaglesDelay() {
        return this.m_naglesDelay == null ? 1000 : this.m_naglesDelay;
    }

    public void setNaglesDelay(Integer naglesDelay) {
        this.m_naglesDelay = naglesDelay;
    }

    public Integer getBatchSize() {
        return this.m_batchSize == null ? 100 : this.m_batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.m_batchSize = batchSize;
    }

    public Integer getQueueSize() {
        return this.m_queueSize == null ? 300000 : this.m_queueSize;
    }

    public void setQueueSize(Integer alarmQueueSize) {
        this.m_queueSize = alarmQueueSize;
    }

    public Boolean isEnabled() {
        return this.m_enabled == null ? Boolean.FALSE : this.m_enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.m_enabled = enabled;
    }

    public SyslogDestination getSyslogDestination(String syslogDestinationName) {
        for (SyslogDestination dest : this.m_destinations) {
            if (!dest.getName().equals(syslogDestinationName)) continue;
            return dest;
        }
        return null;
    }

    public void addSyslogDestination(SyslogDestination syslogDestination) {
        int index = -1;
        for (int i = 0; i < this.m_destinations.size(); ++i) {
            if (!this.m_destinations.get(i).getName().equals(syslogDestination.getName())) continue;
            index = i;
            break;
        }
        if (index > -1) {
            this.m_destinations.remove(index);
            this.m_destinations.add(index, syslogDestination);
        } else {
            this.m_destinations.add(syslogDestination);
        }
    }

    public boolean removeSyslogDestination(String syslogDestinationName) {
        int index = -1;
        for (int i = 0; i < this.m_destinations.size(); ++i) {
            if (!this.m_destinations.get(i).getName().equals(syslogDestinationName)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            this.m_destinations.remove(index);
            return true;
        }
        return false;
    }
}

