/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.commands;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.utils.InetAddressUtils;

@Command(scope="opennms", name="ip-addr-range", description="Returns a list of IP addresses in a given range. Useful with closures.")
@Service
public class IpAddressRangeCommand
implements Action {
    @Argument(index=0, name="start-address", description="First IP address in range", required=true, multiValued=false)
    private String m_startAddress;
    @Argument(index=1, name="end-address", description="Last IP address in range", required=true, multiValued=false)
    private String m_endAddress;

    public Object execute() {
        InetAddress startAddr = null;
        InetAddress endAddr = null;
        try {
            startAddr = InetAddress.getByName(this.m_startAddress);
            endAddr = InetAddress.getByName(this.m_endAddress);
        }
        catch (UnknownHostException uhe) {
            System.out.println(uhe.getMessage());
            return null;
        }
        if (startAddr.getClass() != endAddr.getClass()) {
            System.out.println("Start and end addresses must be of same class (IPv4 / IPv6)");
            return null;
        }
        if (InetAddressUtils.difference((InetAddress)endAddr, (InetAddress)startAddr).longValue() < 1L) {
            System.out.println("Start address must be lower than end address.");
            return null;
        }
        String thisAddr = InetAddressUtils.str((InetAddress)startAddr);
        ArrayList<String> addresses = new ArrayList<String>();
        addresses.add(thisAddr);
        for (int i = 0; i < InetAddressUtils.difference((InetAddress)endAddr, (InetAddress)startAddr).intValue(); ++i) {
            try {
                thisAddr = InetAddressUtils.incr((String)thisAddr);
                addresses.add(thisAddr);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return addresses;
    }
}

