/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.web.api.Authentication;
import org.opennms.web.springframework.security.SpringSecurityUser;
import org.opennms.web.springframework.security.SpringSecurityUserDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;

public class SpringSecurityUserDaoImpl
implements SpringSecurityUserDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SpringSecurityUserDaoImpl.class);
    private UserManager m_userManager;
    private String m_usersConfigurationFile;
    private Map<String, OnmsUser> m_users = null;
    private long m_usersLastModified;
    private Map<String, List<GrantedAuthority>> m_roles = null;
    private Map<String, GrantedAuthority> m_authorities = new HashMap<String, GrantedAuthority>();

    private void parseUsers() throws DataRetrievalFailureException {
        HashMap<String, OnmsUser> users = new HashMap<String, OnmsUser>();
        HashMap<String, List<GrantedAuthority>> roles = new HashMap<String, List<GrantedAuthority>>();
        try {
            for (OnmsUser user : this.m_userManager.getOnmsUserList()) {
                String username = user.getUsername();
                users.put(username, user);
                if (!roles.containsKey(username)) {
                    roles.put(username, new LinkedList());
                }
                for (String role : user.getRoles()) {
                    if (!Authentication.isValidRole((String)role)) continue;
                    ((List)roles.get(username)).add(this.getAuthority(role));
                    if (!"ROLE_ADMIN".equals(role)) continue;
                    ((List)roles.get(username)).add(this.getAuthority("ROLE_USER"));
                }
            }
        }
        catch (Throwable t) {
            throw new DataRetrievalFailureException("Unable to get user list.", t);
        }
        LOG.debug("Loaded the users.xml file with {} users", (Object)users.size());
        this.m_usersLastModified = this.m_userManager.getLastModified();
        this.m_users = users;
        this.m_roles = roles;
    }

    protected GrantedAuthority getAuthority(String role) {
        if (!this.m_authorities.containsKey(role)) {
            this.m_authorities.put(role, (GrantedAuthority)new SimpleGrantedAuthority(role));
        }
        return this.m_authorities.get(role);
    }

    protected Collection<? extends GrantedAuthority> getAuthoritiesByUsername(String username) {
        List<GrantedAuthority> roles;
        if (this.m_roles.containsKey(username) && !(roles = (List<GrantedAuthority>)this.m_roles.get(username)).isEmpty()) {
            LOG.debug("User {} has roles: {}", (Object)username, roles);
            return roles;
        }
        roles = Arrays.asList(ROLE_USER);
        LOG.debug("User {} has roles: {}", (Object)username, roles);
        return roles;
    }

    private boolean isUsersParseNecessary() {
        if (this.m_users == null) {
            return true;
        }
        try {
            this.m_userManager.update();
        }
        catch (Throwable t) {
            LOG.warn("Attempting to update users failed because: {}. Continuing with previous cache of users.", (Object)t.getLocalizedMessage());
        }
        return this.m_usersLastModified != this.m_userManager.getLastModified();
    }

    public void setUsersConfigurationFile(String usersConfigurationFile) {
        this.m_usersConfigurationFile = usersConfigurationFile;
        UserFactory.setInstance(null);
    }

    public String getUsersConfigurationFile() {
        return this.m_usersConfigurationFile;
    }

    @Override
    public SpringSecurityUser getByUsername(String username) {
        this.reloadIfNecessary();
        OnmsUser user = this.m_users.get(username);
        if (user == null) {
            return null;
        }
        SpringSecurityUser springUser = new SpringSecurityUser(user);
        springUser.setAuthorities(this.getAuthoritiesByUsername(username));
        return springUser;
    }

    private void reloadIfNecessary() {
        if (this.isUsersParseNecessary()) {
            this.parseUsers();
        }
    }

    public long getUsersLastModified() {
        return this.m_usersLastModified;
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    public void setUserManager(UserManager mgr) {
        this.m_userManager = mgr;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_usersConfigurationFile != null ? 1 : 0) != 0, (String)"usersConfigurationFile parameter must be set to the location of the users.xml configuration file");
        Assert.notNull((Object)this.m_userManager);
    }
}

