/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;

public class RequestHeaderPreAuthenticationProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestHeaderPreAuthenticationProcessingFilter.class);
    private boolean m_enabled = false;
    private String m_userHeader = null;
    private String m_credentialsHeader = null;
    private String m_authoritiesHeader = null;
    private boolean m_failOnError = false;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.m_enabled) {
            if (StringUtils.isBlank((String)this.m_userHeader)) {
                throw new IllegalStateException("RequestHeaderPreAuthenticationProcessingFilter is enabled but 'userHeader' is not set!");
            }
            if (StringUtils.isBlank((String)this.m_credentialsHeader)) {
                this.m_credentialsHeader = null;
            }
            LOG.debug("Request header pre-authentication filter is enabled.  Access will be pre-authenticated by the user (principal) in the '{}' header on each servlet request.", (Object)this.m_userHeader);
        } else {
            LOG.info("Request header pre-authentication filter is disabled.");
        }
        this.setAuthenticationDetailsSource((org.springframework.security.authentication.AuthenticationDetailsSource)new AuthenticationDetailsSource());
    }

    protected Collection<? extends GrantedAuthority> getGrantedAuthorities(HttpServletRequest context) {
        String roles = "";
        if (this.m_authoritiesHeader != null) {
            roles = context.getHeader(this.m_authoritiesHeader);
        }
        if (StringUtils.isBlank((String)roles)) {
            return Collections.emptyList();
        }
        return Arrays.stream(roles.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        if (this.m_enabled) {
            String user = request.getHeader(this.m_userHeader);
            if (user == null && this.m_failOnError) {
                throw new PreAuthenticatedCredentialsNotFoundException(this.m_userHeader + " header not found in request.");
            }
            return user;
        }
        return null;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        if (this.m_credentialsHeader != null) {
            return request.getHeader(this.m_credentialsHeader);
        }
        return "";
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public void setUserHeader(String userHeader) {
        this.m_userHeader = userHeader;
    }

    public void setCredentialsHeader(String credentialsHeader) {
        this.m_credentialsHeader = credentialsHeader;
    }

    public String getAuthoritiesHeader() {
        return this.m_authoritiesHeader;
    }

    public void setAuthoritiesHeader(String authoritiesHeader) {
        this.m_authoritiesHeader = authoritiesHeader;
    }

    public void setFailOnError(boolean failOnError) {
        this.m_failOnError = failOnError;
    }

    private class AuthenticationDetailsSource
    extends WebAuthenticationDetailsSource {
        private AuthenticationDetailsSource() {
        }

        public WebAuthenticationDetails buildDetails(HttpServletRequest context) {
            return new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(context, RequestHeaderPreAuthenticationProcessingFilter.this.getGrantedAuthorities(context));
        }
    }
}

