/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.util.RedirectUrlBuilder;
import org.springframework.security.web.util.UrlUtils;

public class OpenNMSLoginUrlAuthEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private static final Logger logger = LoggerFactory.getLogger(OpenNMSLoginUrlAuthEntryPoint.class);
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public OpenNMSLoginUrlAuthEntryPoint(String loginFormUrl) {
        super(loginFormUrl);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String redirectUrl = null;
        if (this.isUseForward()) {
            if (this.isHttpsEnabled(request) && "http".equals(request.getScheme())) {
                redirectUrl = this.buildHttpsRedirectUrlForRequest(request);
            }
            if (redirectUrl == null) {
                String loginForm = this.determineUrlToUseForThisRequest(request, response, authException);
                if (logger.isDebugEnabled()) {
                    logger.debug("Server side forward to: {}", (Object)loginForm);
                }
                RequestDispatcher dispatcher = request.getRequestDispatcher(loginForm);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
        } else {
            redirectUrl = this.buildRedirectUrlToLoginPage(request, response, authException);
        }
        this.redirectStrategy.sendRedirect(request, response, redirectUrl);
    }

    protected String buildRedirectUrlToLoginPage(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) {
        URL url;
        String loginForm = this.determineUrlToUseForThisRequest(request, response, authException);
        if (UrlUtils.isAbsoluteUrl((String)loginForm)) {
            return loginForm;
        }
        try {
            url = new URL(Util.calculateUrlBase((HttpServletRequest)request, (String)loginForm));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        RedirectUrlBuilder urlBuilder = new RedirectUrlBuilder();
        urlBuilder.setScheme(url.getProtocol());
        urlBuilder.setServerName(url.getHost());
        urlBuilder.setPort(url.getPort() == -1 ? url.getDefaultPort() : url.getPort());
        urlBuilder.setContextPath(url.getPath());
        urlBuilder.setPathInfo(url.getQuery());
        return urlBuilder.getUrl();
    }

    protected boolean isHttpsEnabled(HttpServletRequest request) {
        return Util.calculateUrlBase((HttpServletRequest)request).startsWith("https:");
    }
}

