/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.node;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.Matcher;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.providers.SearchResultItemBuilder;

public class NodeAssetSearchProvider
implements SearchProvider {
    private final NodeDao nodeDao;
    private final EntityScopeProvider entityScopeProvider;

    public NodeAssetSearchProvider(NodeDao nodeDao, EntityScopeProvider entityScopeProvider) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.entityScopeProvider = Objects.requireNonNull(entityScopeProvider);
    }

    public SearchContext getContext() {
        return Contexts.Node;
    }

    public SearchResult query(SearchQuery query) {
        String input = query.getInput();
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class).alias("assetRecord", "assetRecord").and(new Restriction[]{Restrictions.isNotNull((String)"assetRecord"), Restrictions.or((Restriction[])new Restriction[]{Restrictions.ilike((String)"assetRecord.category", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.manufacturer", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.vendor", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.modelNumber", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.serialNumber", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.description", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.circuitId", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.assetNumber", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.operatingSystem", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.rack", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.slot", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.port", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.region", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.division", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.department", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.building", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.floor", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.room", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.vendorPhone", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.vendorFax", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.vendorAssetNumber", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.username", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.connection", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.lease", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.leaseExpires", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.supportPhone", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.maintContractExpiration", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.maintcontract", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.displayCategory", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.pollerCategory", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.thresholdCategory", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.comment", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.cpu", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.ram", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.hdd1", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.hdd2", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.hdd3", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.hdd4", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.hdd5", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.hdd6", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.numpowersupplies", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.inputpower", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.additionalhardware", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.admin", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.snmpcommunity", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.rackunitheight", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.managedObjectType", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.managedObjectInstance", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.storagectrl", (Object)QueryUtils.ilike((String)input))})}).distinct();
        int totalCount = this.nodeDao.countMatching(criteriaBuilder.toCriteria());
        List matchingNodes = this.nodeDao.findMatching(criteriaBuilder.orderBy("label").limit(Integer.valueOf(query.getMaxResults())).toCriteria());
        List results = matchingNodes.stream().map(node -> {
            SearchResultItem result = new SearchResultItemBuilder().withOnmsNode((OnmsNode)node, this.entityScopeProvider).build();
            OnmsAssetRecord record = node.getAssetRecord();
            ArrayList matcherList = Lists.newArrayList((Object[])new Matcher[]{new Matcher("Category", record.getCategory()), new Matcher("ManuFacturer", record.getManufacturer()), new Matcher("Vendor", record.getVendor()), new Matcher("Model Number", record.getModelNumber()), new Matcher("Serial Number", record.getSerialNumber()), new Matcher("Description", record.getDescription()), new Matcher("Circuit Id", record.getCircuitId()), new Matcher("Asset Number", record.getAssetNumber()), new Matcher("OS", record.getOperatingSystem()), new Matcher("Rack", record.getRack()), new Matcher("Slot", record.getSlot()), new Matcher("Port", record.getPort()), new Matcher("Region", record.getRegion()), new Matcher("Division", record.getDivision()), new Matcher("Department", record.getDepartment()), new Matcher("Building", record.getBuilding()), new Matcher("Floor", record.getFloor()), new Matcher("Room", record.getRoom()), new Matcher("Vendor Phone", record.getVendorPhone()), new Matcher("Vendor Fax", record.getVendorFax()), new Matcher("Vendor Asset Number", record.getVendorAssetNumber()), new Matcher("Username", record.getUsername()), new Matcher("Connection", record.getConnection()), new Matcher("Lease", record.getLease()), new Matcher("Lease Expires", record.getLeaseExpires()), new Matcher("Support Phone", record.getSupportPhone()), new Matcher("Maint. Contract Expiration", record.getMaintContractExpiration()), new Matcher("Maint. Contract", record.getMaintcontract()), new Matcher("Display Category", record.getDisplayCategory()), new Matcher("Poller Category", record.getPollerCategory()), new Matcher("Threshold Category", record.getThresholdCategory()), new Matcher("Comment", record.getComment()), new Matcher("CPU", record.getCpu()), new Matcher("Ram", record.getRam()), new Matcher("HDD1", record.getHdd1()), new Matcher("HDD2", record.getHdd2()), new Matcher("HDD3", record.getHdd3()), new Matcher("HDD4", record.getHdd4()), new Matcher("HDD5", record.getHdd5()), new Matcher("HDD6", record.getHdd6()), new Matcher("# Power Supplies", record.getNumpowersupplies()), new Matcher("Input Power", record.getInputpower()), new Matcher("Additional Hardware", record.getAdditionalhardware()), new Matcher("admin", record.getAdmin()), new Matcher("SNMP Community", record.getSnmpcommunity()), new Matcher("RU Height", record.getRackunitheight()), new Matcher("Managed Object Type", record.getManagedObjectType()), new Matcher("Managed Object Instance", record.getManagedObjectInstance()), new Matcher("Storage Controller", record.getStoragectrl())});
            result.addMatches((List)matcherList, input);
            return result;
        }).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(Contexts.Node).withMore(totalCount > results.size()).withResults(results);
        return searchResult;
    }
}

