/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.action;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.api.UrlUtils;

public class LocationSearchProvider
implements SearchProvider {
    private final MonitoringLocationDao monitoringLocationDao;

    public LocationSearchProvider(MonitoringLocationDao monitoringLocationDao) {
        this.monitoringLocationDao = Objects.requireNonNull(monitoringLocationDao);
    }

    public SearchContext getContext() {
        return Contexts.Action;
    }

    public SearchResult query(SearchQuery query) {
        String input = query.getInput();
        CriteriaBuilder builder = new CriteriaBuilder(OnmsMonitoringLocation.class).ilike("locationName", QueryUtils.ilike((String)input)).orderBy("locationName").distinct();
        int totalCount = this.monitoringLocationDao.countMatching(builder.toCriteria());
        Criteria criteria = builder.limit(Integer.valueOf(query.getMaxResults())).toCriteria();
        List matchingResult = this.monitoringLocationDao.findMatching(criteria);
        List searchResultItems = matchingResult.stream().map(monitoringLocation -> {
            SearchResultItem searchResultItem = new SearchResultItem();
            searchResultItem.setIdentifier(monitoringLocation.getLocationName());
            searchResultItem.setLabel("Show nodes in location '" + monitoringLocation.getLocationName() + "'");
            searchResultItem.setUrl("element/nodeList.htm?monitoringLocation=" + UrlUtils.encode((String)monitoringLocation.getLocationName()));
            return searchResultItem;
        }).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(Contexts.Action).withMore(totalCount > searchResultItems.size()).withResults(searchResultItems);
        return searchResult;
    }
}

