/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.api;

import java.util.Objects;
import org.opennms.web.rest.api.ApiVersion;

public class ResourceLocation {
    private ApiVersion version;
    private String path;

    public ResourceLocation() {
    }

    public ResourceLocation(ApiVersion version, String ... path) {
        this.version = Objects.requireNonNull(version);
        this.setPath(path);
    }

    private void setPath(String ... path) {
        Objects.requireNonNull(path);
        StringBuilder pathBuilder = new StringBuilder();
        for (String eachPath : path) {
            pathBuilder.append(eachPath);
            if (eachPath.endsWith("/")) continue;
            pathBuilder.append("/");
        }
        this.path = pathBuilder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.version.getContextPath());
        builder.append(this.path);
        String pathString = builder.toString();
        if (pathString.endsWith("/")) {
            pathString = pathString.substring(0, pathString.length() - 1);
        }
        return pathString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceLocation other = (ResourceLocation)obj;
        boolean equals = Objects.equals((Object)this.version, (Object)other.version) && Objects.equals(this.path, other.path);
        return equals;
    }

    public static ResourceLocation parse(String locationString) {
        ApiVersion version = Objects.requireNonNull(ResourceLocation.getApiVersion(locationString));
        String path = locationString.replaceFirst(version.getContextPath(), "");
        return new ResourceLocation(version, path);
    }

    private static ApiVersion getApiVersion(String locationString) {
        for (ApiVersion eachVersion : ApiVersion.values()) {
            if (!locationString.startsWith(eachVersion.getContextPath())) continue;
            return eachVersion;
        }
        return null;
    }
}

