/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.ui.Label;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.opennms.features.vaadin.dashboard.model.AbstractDashlet;
import org.opennms.features.vaadin.dashboard.model.AbstractDashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;

public class GrafanaDashlet
extends AbstractDashlet {
    private DashletComponent m_dashletComponent;

    public GrafanaDashlet(String name, DashletSpec dashletSpec) {
        super(name, dashletSpec);
    }

    public DashletComponent getWallboardComponent(UI ui) {
        if (this.m_dashletComponent == null) {
            this.m_dashletComponent = new AbstractDashletComponent(){
                private VerticalLayout m_verticalLayout = new VerticalLayout();
                {
                    this.m_verticalLayout.setCaption(GrafanaDashlet.this.getName());
                    this.m_verticalLayout.setSizeFull();
                }

                public void refresh() {
                    this.m_verticalLayout.removeAllComponents();
                    String uri = "";
                    String from = "";
                    String to = "";
                    if (GrafanaDashlet.this.getDashletSpec().getParameters().containsKey("uri")) {
                        uri = (String)GrafanaDashlet.this.getDashletSpec().getParameters().get("uri");
                    }
                    if (GrafanaDashlet.this.getDashletSpec().getParameters().containsKey("from")) {
                        from = (String)GrafanaDashlet.this.getDashletSpec().getParameters().get("from");
                    }
                    if (GrafanaDashlet.this.getDashletSpec().getParameters().containsKey("to")) {
                        to = (String)GrafanaDashlet.this.getDashletSpec().getParameters().get("to");
                    }
                    if (!"".equals(uri)) {
                        String grafanaProtocol = System.getProperty("org.opennms.grafanaBox.protocol", "http");
                        String grafanaHostname = System.getProperty("org.opennms.grafanaBox.hostname", "localhost");
                        int grafanaPort = Integer.parseInt(System.getProperty("org.opennms.grafanaBox.port", "3000"));
                        try {
                            URL url = new URL(String.format("%s://%s:%d/dashboard/%s?from=%s&to=%s", grafanaProtocol, grafanaHostname, grafanaPort, uri, URLEncoder.encode(from, "UTF-8"), URLEncoder.encode(to, "UTF-8")));
                            BrowserFrame browserFrame = new BrowserFrame(null, (Resource)new ExternalResource(url));
                            browserFrame.setSizeFull();
                            this.m_verticalLayout.addComponent((Component)browserFrame);
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        catch (MalformedURLException e) {
                            this.m_verticalLayout.addComponent((Component)new Label("MalformedURLException: " + e.getMessage()));
                            return;
                        }
                    } else {
                        this.m_verticalLayout.addComponent((Component)new Label("No URL specified!"));
                    }
                }

                public Component getComponent() {
                    return this.m_verticalLayout;
                }
            };
        }
        return this.m_dashletComponent;
    }

    public DashletComponent getDashboardComponent(UI ui) {
        return this.getWallboardComponent(ui);
    }
}

