/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.MetricAggregation;
import io.searchbox.core.search.aggregation.RootAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.util.ArrayList;
import java.util.List;
import org.opennms.features.elastic.client.model.SearchResponse;
import org.opennms.netmgt.flows.elastic.ProportionalSumAggregation;

public class AggregationUtils {
    public static MetricAggregation toMetricAggregation(SearchResponse response) {
        if (response.getAggregations() == null) {
            return null;
        }
        RootAggregation root = new RootAggregation("root", response.getAggregations());
        return root;
    }

    public static TermsAggregation getTermsAggregation(JsonObject aggregations, String name) {
        if (aggregations == null || !aggregations.has(name)) {
            return null;
        }
        JsonObject termsAgg = aggregations.getAsJsonObject(name);
        return new TermsAggregation(name, termsAgg);
    }

    public static ProportionalSumAggregation getProportionalSumAggregation(JsonObject aggregations, String name) {
        if (aggregations == null || !aggregations.has(name)) {
            return null;
        }
        JsonObject sumAgg = aggregations.getAsJsonObject(name);
        return new ProportionalSumAggregation(name, sumAgg);
    }

    public static JsonObject getFirstHitSource(SearchResponse response) {
        if (response.getHits() != null && response.getHits().getHits() != null && !response.getHits().getHits().isEmpty()) {
            return ((SearchResponse.SearchHit)response.getHits().getHits().get(0)).getSource();
        }
        return null;
    }

    public static List<JsonObject> getTermsBuckets(JsonObject aggregations, String aggName) {
        JsonObject termsAgg;
        ArrayList<JsonObject> buckets = new ArrayList<JsonObject>();
        if (aggregations != null && aggregations.has(aggName) && (termsAgg = aggregations.getAsJsonObject(aggName)).has("buckets") && termsAgg.get("buckets").isJsonArray()) {
            JsonArray bucketsArray = termsAgg.getAsJsonArray("buckets");
            for (JsonElement bucket : bucketsArray) {
                if (!bucket.isJsonObject()) continue;
                buckets.add(bucket.getAsJsonObject());
            }
        }
        return buckets;
    }
}

