/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.collectors.resource.StringAttribute;

public final class ImmutableStringAttribute
implements StringAttribute {
    private final String name;
    private final String group;
    private final String value;

    private ImmutableStringAttribute(Builder builder) {
        this.name = builder.name;
        this.group = builder.group;
        this.value = builder.value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(StringAttribute stringAttribute) {
        return new Builder(stringAttribute);
    }

    public static StringAttribute immutableCopy(StringAttribute stringAttribute) {
        if (stringAttribute == null || stringAttribute instanceof ImmutableStringAttribute) {
            return stringAttribute;
        }
        return ImmutableStringAttribute.newBuilderFrom(stringAttribute).build();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableStringAttribute that = (ImmutableStringAttribute)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.group, that.group) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.group, this.value);
    }

    public String toString() {
        return "ImmutableStringAttribute{name='" + this.name + "', group='" + this.group + "', value='" + this.value + "'}";
    }

    public static final class Builder {
        private String name;
        private String group;
        private String value;

        private Builder() {
        }

        private Builder(StringAttribute stringAttribute) {
            this.name = stringAttribute.getName();
            this.group = stringAttribute.getGroup();
            this.value = stringAttribute.getValue();
        }

        public Builder setName(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder setValue(String value) {
            this.value = Objects.requireNonNull(value);
            return this;
        }

        public ImmutableStringAttribute build() {
            Objects.requireNonNull(this.name, "name is required");
            Objects.requireNonNull(this.value, "value is required");
            return new ImmutableStringAttribute(this);
        }
    }
}

