/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.events.sink.dispatcher;

import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.MessageDispatcherFactory;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.features.events.sink.module.EventSinkModule;
import org.opennms.netmgt.config.api.EventdConfig;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcherImpl
implements EventForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(EventDispatcherImpl.class);
    private MessageDispatcherFactory messageDispatcherFactory;
    private AsyncDispatcher<Event> asyncDispatcher;
    private EventdConfig eventdConfig;

    public EventDispatcherImpl(MessageDispatcherFactory messageDispatcherFactory, EventdConfig eventdConfig) {
        this.messageDispatcherFactory = messageDispatcherFactory;
        this.eventdConfig = eventdConfig;
    }

    public void sendNow(Event event) {
        try {
            this.getAsyncDispatcher().send((Message)event).whenComplete((t, ex) -> {
                if (ex != null) {
                    LOG.error("Failed to sent Event with uei = {}", (Object)event.getUei(), ex);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Failed to sent Event with uei = {}", (Object)event.getUei(), (Object)e);
        }
    }

    public void sendNow(Log eventLog) {
        eventLog.getEvents().getEventCollection().forEach(this::sendNow);
    }

    public void sendNowSync(Event event) {
        this.sendNow(event);
    }

    public void sendNowSync(Log eventLog) {
        this.sendNow(eventLog);
    }

    public AsyncDispatcher<Event> getAsyncDispatcher() {
        if (this.asyncDispatcher == null) {
            this.asyncDispatcher = this.messageDispatcherFactory.createAsyncDispatcher((SinkModule)new EventSinkModule(this.eventdConfig));
        }
        return this.asyncDispatcher;
    }
}

