/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.transport;

import com.google.protobuf.UInt32Value;
import java.net.InetAddress;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.RecordEnrichment;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.MessageBuilder;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.MessageUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.Timeout;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.Direction;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.FlowMessage;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.NetflowVersion;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.SamplingAlgorithm;

public class Netflow9MessageBuilder
implements MessageBuilder {
    private Long flowActiveTimeoutFallback;
    private Long flowInactiveTimeoutFallback;
    private Long flowSamplingIntervalFallback;

    @Override
    public FlowMessage.Builder buildMessage(Iterable<Value<?>> values, RecordEnrichment enrichment) {
        FlowMessage.Builder builder = FlowMessage.newBuilder();
        builder.setDirection(Direction.UNKNOWN);
        InetAddress ipv4DstAddress = null;
        InetAddress ipv6DstAddress = null;
        Long dstMask = null;
        Long ipv6DstMask = null;
        InetAddress ipv4NextHop = null;
        InetAddress ipv6NextHop = null;
        InetAddress bgpIpv4NextHop = null;
        InetAddress bgpIpv6NextHop = null;
        InetAddress ipv4SrcAddress = null;
        InetAddress ipv6SrcAddress = null;
        Long srcMask = null;
        Long ipv6SrcMask = null;
        Long srcVlan = null;
        Long dstVlan = null;
        Long flowActiveTimeout = this.flowActiveTimeoutFallback;
        Long flowInActiveTimeout = this.flowInactiveTimeoutFallback;
        long sysUpTime = 0L;
        long unixSecs = 0L;
        Long firstSwitched = null;
        Long lastSwitched = null;
        Long flowStartMilliseconds = null;
        Long flowEndMilliseconds = null;
        UInt32Value ingressPhysicalInterface = null;
        UInt32Value egressPhysicalInterface = null;
        UInt32Value inputSnmp = null;
        UInt32Value outputSnmp = null;
        if (this.flowSamplingIntervalFallback != null) {
            builder.setSamplingInterval(MessageUtils.setDoubleValue(this.flowSamplingIntervalFallback.longValue()));
        }
        for (Value<?> value : values) {
            switch (value.getName()) {
                case "@recordCount": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setNumFlowRecords(arg_0));
                    break;
                }
                case "@sequenceNumber": {
                    MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setFlowSeqNum(arg_0));
                    break;
                }
                case "@sourceId": {
                    MessageUtils.getUInt64Value(value).ifPresent(srcId -> builder.setNodeIdentifier(String.valueOf(srcId.getValue())));
                    break;
                }
                case "@sysUpTime": {
                    sysUpTime = MessageUtils.getLongValue(value);
                    break;
                }
                case "@unixSecs": {
                    unixSecs = MessageUtils.getLongValue(value);
                    break;
                }
                case "IN_BYTES": {
                    MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setNumBytes(arg_0));
                    break;
                }
                case "DIRECTION": {
                    builder.setDirection(Netflow9MessageBuilder.getDirection(value));
                    break;
                }
                case "IPV4_DST_ADDR": {
                    ipv4DstAddress = MessageUtils.getInetAddress(value);
                    break;
                }
                case "IPV6_DST_ADDR": {
                    ipv6DstAddress = MessageUtils.getInetAddress(value);
                    break;
                }
                case "DST_AS": {
                    MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setDstAs(arg_0));
                    break;
                }
                case "IPV6_DST_MASK": {
                    ipv6DstMask = MessageUtils.getLongValue(value);
                    break;
                }
                case "DST_MASK": {
                    dstMask = MessageUtils.getLongValue(value);
                    break;
                }
                case "L4_DST_PORT": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setDstPort(arg_0));
                    break;
                }
                case "ENGINE_ID": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setEngineId(arg_0));
                    break;
                }
                case "ENGINE_TYPE": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setEngineType(arg_0));
                    break;
                }
                case "FIRST_SWITCHED": {
                    firstSwitched = MessageUtils.getLongValue(value);
                    break;
                }
                case "LAST_SWITCHED": {
                    lastSwitched = MessageUtils.getLongValue(value);
                    break;
                }
                case "INPUT_SNMP": {
                    inputSnmp = MessageUtils.getUInt32Value(value).orElse(null);
                    break;
                }
                case "IP_PROTOCOL_VERSION": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setIpProtocolVersion(arg_0));
                    break;
                }
                case "OUTPUT_SNMP": {
                    outputSnmp = MessageUtils.getUInt32Value(value).orElse(null);
                    break;
                }
                case "IPV6_NEXT_HOP": {
                    ipv6NextHop = MessageUtils.getInetAddress(value);
                    break;
                }
                case "IPV4_NEXT_HOP": {
                    ipv4NextHop = MessageUtils.getInetAddress(value);
                    break;
                }
                case "BPG_IPV6_NEXT_HOP": {
                    bgpIpv6NextHop = MessageUtils.getInetAddress(value);
                    break;
                }
                case "BPG_IPV4_NEXT_HOP": {
                    bgpIpv4NextHop = MessageUtils.getInetAddress(value);
                    break;
                }
                case "IN_PKTS": {
                    MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setNumPackets(arg_0));
                    break;
                }
                case "PROTOCOL": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setProtocol(arg_0));
                    break;
                }
                case "SAMPLING_ALGORITHM": {
                    builder.setSamplingAlgorithm(Netflow9MessageBuilder.getSamplingAlgorithm(value));
                    break;
                }
                case "SAMPLING_INTERVAL": {
                    MessageUtils.getDoubleValue(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setSamplingInterval(arg_0));
                    break;
                }
                case "IPV6_SRC_ADDR": {
                    ipv6SrcAddress = MessageUtils.getInetAddress(value);
                    break;
                }
                case "IPV4_SRC_ADDR": {
                    ipv4SrcAddress = MessageUtils.getInetAddress(value);
                    break;
                }
                case "IPV6_SRC_MASK": {
                    ipv6SrcMask = MessageUtils.getLongValue(value);
                    break;
                }
                case "SRC_MASK": {
                    srcMask = MessageUtils.getLongValue(value);
                    break;
                }
                case "SRC_AS": {
                    MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setSrcAs(arg_0));
                    break;
                }
                case "L4_SRC_PORT": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setSrcPort(arg_0));
                    break;
                }
                case "TCP_FLAGS": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setTcpFlags(arg_0));
                    break;
                }
                case "TOS": {
                    MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setTos(arg_0));
                    break;
                }
                case "SRC_VLAN": {
                    srcVlan = MessageUtils.getLongValue(value);
                    break;
                }
                case "DST_VLAN": {
                    dstVlan = MessageUtils.getLongValue(value);
                    break;
                }
                case "FLOW_ACTIVE_TIMEOUT": {
                    flowActiveTimeout = MessageUtils.getLongValue(value);
                    break;
                }
                case "FLOW_INACTIVE_TIMEOUT": {
                    flowInActiveTimeout = MessageUtils.getLongValue(value);
                    break;
                }
                case "flowStartMilliseconds": {
                    flowStartMilliseconds = MessageUtils.getLongValue(value);
                    break;
                }
                case "flowEndMilliseconds": {
                    flowEndMilliseconds = MessageUtils.getLongValue(value);
                    break;
                }
                case "ingressPhysicalInterface": {
                    ingressPhysicalInterface = MessageUtils.getUInt32Value(value).orElse(null);
                    break;
                }
                case "egressPhysicalInterface": {
                    egressPhysicalInterface = MessageUtils.getUInt32Value(value).orElse(null);
                    break;
                }
            }
        }
        long timeStampInMsecs = unixSecs * 1000L;
        builder.setTimestamp(timeStampInMsecs);
        long bootTime = timeStampInMsecs - sysUpTime;
        if (firstSwitched != null) {
            builder.setFirstSwitched(MessageUtils.setLongValue(firstSwitched + bootTime));
        } else if (flowStartMilliseconds != null) {
            builder.setFirstSwitched(MessageUtils.setLongValue(flowStartMilliseconds));
        }
        if (lastSwitched != null) {
            builder.setLastSwitched(MessageUtils.setLongValue(lastSwitched + bootTime));
        } else if (flowEndMilliseconds != null) {
            builder.setLastSwitched(MessageUtils.setLongValue(flowEndMilliseconds));
        }
        MessageUtils.first(ingressPhysicalInterface, inputSnmp).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setInputSnmpIfindex(arg_0));
        MessageUtils.first(egressPhysicalInterface, outputSnmp).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setOutputSnmpIfindex(arg_0));
        MessageUtils.first(ipv6DstAddress, ipv4DstAddress).ifPresent(inetAddress -> {
            enrichment.getHostnameFor((InetAddress)inetAddress).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setDstHostname(arg_0));
            builder.setDstAddress(inetAddress.getHostAddress());
        });
        MessageUtils.first(ipv6DstMask, dstMask).ifPresent(dstMaskLen -> builder.setDstMaskLen(MessageUtils.setIntValue(dstMaskLen.intValue())));
        MessageUtils.first(ipv6SrcAddress, ipv4SrcAddress).ifPresent(inetAddress -> {
            enrichment.getHostnameFor((InetAddress)inetAddress).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setSrcHostname(arg_0));
            builder.setSrcAddress(inetAddress.getHostAddress());
        });
        MessageUtils.first(ipv6SrcMask, srcMask).ifPresent(srcMaskLen -> builder.setSrcMaskLen(MessageUtils.setIntValue(srcMaskLen.intValue())));
        MessageUtils.first(ipv6NextHop, ipv4NextHop, bgpIpv6NextHop, bgpIpv4NextHop).ifPresent(inetAddress -> {
            enrichment.getHostnameFor((InetAddress)inetAddress).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setNextHopHostname(arg_0));
            builder.setNextHopAddress(inetAddress.getHostAddress());
        });
        MessageUtils.first(srcVlan, dstVlan).ifPresent(vlan -> builder.setVlan(MessageUtils.setIntValue(vlan.intValue())));
        Timeout timeout = new Timeout(flowActiveTimeout, flowInActiveTimeout);
        timeout.setFirstSwitched(builder.hasFirstSwitched() ? Long.valueOf(builder.getFirstSwitched().getValue()) : null);
        timeout.setLastSwitched(builder.hasLastSwitched() ? Long.valueOf(builder.getLastSwitched().getValue()) : null);
        timeout.setNumBytes(builder.getNumBytes().getValue());
        timeout.setNumPackets(builder.getNumPackets().getValue());
        Long deltaSwitched = timeout.getDeltaSwitched();
        MessageUtils.getUInt64Value(deltaSwitched).ifPresent(arg_0 -> ((FlowMessage.Builder)builder).setDeltaSwitched(arg_0));
        builder.setNetflowVersion(NetflowVersion.V9);
        return builder;
    }

    private static Direction getDirection(Value<?> value) {
        Long directionValue = MessageUtils.getLongValue(value);
        Direction direction = Direction.UNKNOWN;
        if (directionValue != null) {
            switch (directionValue.intValue()) {
                case 0: {
                    direction = Direction.INGRESS;
                    break;
                }
                case 1: {
                    direction = Direction.EGRESS;
                    break;
                }
            }
        }
        return direction;
    }

    private static SamplingAlgorithm getSamplingAlgorithm(Value<?> value) {
        Long saValue = MessageUtils.getLongValue(value);
        SamplingAlgorithm samplingAlgorithm = SamplingAlgorithm.UNASSIGNED;
        if (saValue != null) {
            switch (saValue.intValue()) {
                case 1: {
                    samplingAlgorithm = SamplingAlgorithm.SYSTEMATIC_COUNT_BASED_SAMPLING;
                    break;
                }
                case 2: {
                    samplingAlgorithm = SamplingAlgorithm.RANDOM_N_OUT_OF_N_SAMPLING;
                    break;
                }
            }
        }
        return samplingAlgorithm;
    }

    public Long getFlowActiveTimeoutFallback() {
        return this.flowActiveTimeoutFallback;
    }

    public void setFlowActiveTimeoutFallback(Long flowActiveTimeoutFallback) {
        this.flowActiveTimeoutFallback = flowActiveTimeoutFallback;
    }

    public Long getFlowInactiveTimeoutFallback() {
        return this.flowInactiveTimeoutFallback;
    }

    public void setFlowInactiveTimeoutFallback(Long flowInactiveTimeoutFallback) {
        this.flowInactiveTimeoutFallback = flowInactiveTimeoutFallback;
    }

    public Long getFlowSamplingIntervalFallback() {
        return this.flowSamplingIntervalFallback;
    }

    public void setFlowSamplingIntervalFallback(Long flowSamplingIntervalFallback) {
        this.flowSamplingIntervalFallback = flowSamplingIntervalFallback;
    }
}

