/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.state;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class TemplateState {
    public final int templateId;
    public final Duration age;

    public TemplateState(Builder builder) {
        this.templateId = builder.templateId;
        this.age = Objects.requireNonNull(builder.age);
    }

    public static Builder builder(int templateId) {
        return new Builder(templateId);
    }

    public static class Builder {
        private int templateId;
        private Duration age;

        private Builder(int templateId) {
            this.templateId = templateId;
        }

        public Builder withTemplateId(int templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder withAge(Duration age) {
            this.age = age;
            return this;
        }

        public Builder withInsertionTime(Instant insertionTime) {
            return this.withAge(Duration.between(insertionTime, Instant.now()));
        }

        public TemplateState build() {
            return new TemplateState(this);
        }
    }
}

