/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.processing.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opennms.integration.api.v1.flows.FlowException;
import org.opennms.integration.api.v1.flows.FlowRepository;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.api.FlowSource;
import org.opennms.netmgt.flows.processing.Pipeline;
import org.opennms.netmgt.flows.processing.ProcessingOptions;
import org.opennms.netmgt.flows.processing.enrichment.EnrichedFlow;
import org.opennms.netmgt.flows.processing.impl.DocumentEnricherImpl;
import org.opennms.netmgt.flows.processing.impl.FlowThresholdingImpl;
import org.opennms.netmgt.flows.processing.impl.InterfaceMarkerImpl;
import org.opennms.netmgt.threshd.api.ThresholdInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineImpl
implements Pipeline {
    public static final String REPOSITORY_ID = "flows.repository.id";
    private static final Logger LOG = LoggerFactory.getLogger(PipelineImpl.class);
    private final Timer logEnrichementTimer;
    private final Timer logThresholdingTimer;
    private final Timer logMarkingTimer;
    private final Histogram flowsPerLog;
    private final Counter emptyFlows;
    private final MetricRegistry metricRegistry;
    private final DocumentEnricherImpl documentEnricher;
    private final InterfaceMarkerImpl interfaceMarker;
    private final FlowThresholdingImpl thresholding;
    private final Map<String, Persister> persisters = Maps.newConcurrentMap();

    public PipelineImpl(MetricRegistry metricRegistry, DocumentEnricherImpl documentEnricher, InterfaceMarkerImpl interfaceMarker, FlowThresholdingImpl thresholding) {
        this.documentEnricher = Objects.requireNonNull(documentEnricher);
        this.interfaceMarker = Objects.requireNonNull(interfaceMarker);
        this.thresholding = Objects.requireNonNull(thresholding);
        this.emptyFlows = metricRegistry.counter("emptyFlows");
        this.flowsPerLog = metricRegistry.histogram("flowsPerLog");
        this.logEnrichementTimer = metricRegistry.timer("logEnrichment");
        this.logMarkingTimer = metricRegistry.timer("logMarking");
        this.logThresholdingTimer = metricRegistry.timer("logThresholding");
        this.metricRegistry = Objects.requireNonNull(metricRegistry);
    }

    @Override
    public void process(List<Flow> flows, FlowSource source, ProcessingOptions processingOptions) throws FlowException {
        List<EnrichedFlow> enrichedFlows;
        Timer.Context ctx;
        this.flowsPerLog.update(flows.size());
        if (flows.isEmpty()) {
            this.emptyFlows.inc();
            LOG.info("Received empty flows from {} @ {}. Nothing to do.", (Object)source.getSourceAddress(), (Object)source.getLocation());
            return;
        }
        LOG.debug("Enriching {} flow documents.", (Object)flows.size());
        try {
            ctx = this.logEnrichementTimer.time();
            try {
                enrichedFlows = this.documentEnricher.enrich(flows, source);
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
        catch (Exception e) {
            throw new FlowException("Failed to enrich one or more flows.", (Throwable)e);
        }
        ctx = this.logMarkingTimer.time();
        try {
            this.interfaceMarker.mark(enrichedFlows);
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        try {
            ctx = this.logThresholdingTimer.time();
            try {
                this.thresholding.threshold(enrichedFlows, processingOptions);
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
        catch (ExecutionException | ThresholdInitializationException e) {
            throw new FlowException("Failed to threshold one or more flows.", e);
        }
        for (Map.Entry<String, Persister> persister : this.persisters.entrySet()) {
            persister.getValue().persist(enrichedFlows);
        }
    }

    public synchronized void onBind(FlowRepository repository, Map properties) {
        if (properties.get(REPOSITORY_ID) == null) {
            LOG.error("Flow repository has no repository ID defined. Ignoring...");
            return;
        }
        String pid = Objects.toString(properties.get(REPOSITORY_ID));
        this.persisters.put(pid, new Persister(repository, this.metricRegistry.timer(MetricRegistry.name((String)"logPersisting", (String[])new String[]{pid}))));
    }

    public synchronized void onUnbind(FlowRepository repository, Map properties) {
        if (properties.get(REPOSITORY_ID) == null) {
            LOG.error("Flow repository has no repository ID defined. Ignoring...");
            return;
        }
        String pid = Objects.toString(properties.get(REPOSITORY_ID));
        this.persisters.remove(pid);
    }

    private static class Persister {
        public final FlowRepository repository;
        public final Timer logTimer;

        public Persister(FlowRepository repository, Timer logTimer) {
            this.repository = Objects.requireNonNull(repository);
            this.logTimer = Objects.requireNonNull(logTimer);
        }

        public void persist(Collection<EnrichedFlow> flows) throws FlowException {
            try (Timer.Context ctx = this.logTimer.time();){
                this.repository.persist(flows);
            }
        }
    }
}

