/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.support;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Date;
import java.util.Properties;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.upgrade.api.OnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;

public class UpgradeStatus {
    public static final String STATUS_FILE = "opennms-upgrade-status.properties";
    private Properties status;
    private File statusFile;

    public UpgradeStatus() throws OnmsUpgradeException {
        this(new File(ConfigFileConstants.getFilePathString() + STATUS_FILE));
    }

    public UpgradeStatus(File statusFile) throws OnmsUpgradeException {
        this.statusFile = statusFile;
        this.status = new Properties();
        try {
            if (statusFile.exists()) {
                this.status.load(new FileReader(statusFile));
            }
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't load upgrade status data.", e);
        }
    }

    public boolean wasExecuted(OnmsUpgrade upg) {
        for (Object obj : this.status.keySet()) {
            String cls = (String)obj;
            if (!cls.equals(upg.getId())) continue;
            return true;
        }
        return false;
    }

    public String getLastExecutionTime(OnmsUpgrade upg) {
        for (Object obj : this.status.keySet()) {
            String cls = (String)obj;
            if (!cls.equals(upg.getId())) continue;
            return this.status.getProperty(cls);
        }
        return "Never";
    }

    public void markAsExecuted(OnmsUpgrade upg) throws OnmsUpgradeException {
        this.status.put(upg.getId(), new Date().toString());
        try {
            this.status.store(new FileWriter(this.statusFile), null);
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't save upgrade status.", e);
        }
    }
}

