/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.upgrade.implementations.SnmpInterface;

public class SnmpInterfaceUpgrade
extends SnmpInterface {
    private File nodeDir;

    public SnmpInterfaceUpgrade(int nodeId, String foreignSource, String foreignId, String ifDescr, String ifName, String physAddr, boolean storeByForeignSource) {
        super(nodeId, foreignSource, foreignId, ifDescr, ifName, physAddr, storeByForeignSource);
    }

    public SnmpInterfaceUpgrade(ResultSet rs, boolean storeByForeignSource) throws SQLException {
        super(rs, storeByForeignSource);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.nodeDir = this.getNodeDirectory(this.getNodeId(), this.getForeignSource(), this.getForeignId());
    }

    public File getNodeDir() {
        return this.nodeDir;
    }

    public File getOldInterfaceDir() {
        return new File(this.getNodeDir(), this.getOldRrdLabel());
    }

    public File getNewInterfaceDir() {
        return new File(this.getNodeDir(), this.getNewRrdLabel());
    }

    public boolean shouldMerge() {
        return this.getOldInterfaceDir().exists() && !this.getOldRrdLabel().equals(this.getNewRrdLabel());
    }

    protected File getNodeDirectory(int nodeId, String foreignSource, String foreignId) {
        String rrdPath = DataCollectionConfigFactory.getInstance().getRrdPath();
        File dir = new File(rrdPath, String.valueOf(nodeId));
        if (Boolean.getBoolean("org.opennms.rrd.storeByForeignSource") && foreignSource != null && foreignId != null) {
            File fsDir = new File(rrdPath, "fs" + File.separatorChar + foreignSource);
            dir = new File(fsDir, foreignId);
        }
        return dir;
    }

    @Override
    public String toString() {
        return "Interface[ifName=" + this.getIfName() + ", nodeId=" + this.getNodeId() + ", foreignSource=" + this.getForeignSource() + ", foreignId=" + this.getForeignId() + ", directory=" + this.getNewInterfaceDir().toString() + "]";
    }
}

