/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.parsers.DOMParser;
import org.opennms.core.utils.BundleLists;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;
import org.opennms.web.api.Authentication;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MagicUsersMigratorOffline
extends AbstractOnmsUpgrade {
    private File magicUsersFile;
    private File magicUsersFileRPM;
    private File magicUsersFileDEB;
    private File usersFile;

    public MagicUsersMigratorOffline() throws OnmsUpgradeException {
        try {
            this.magicUsersFile = new File(ConfigFileConstants.getHome(), "etc" + File.separator + "magic-users.properties");
            this.magicUsersFileRPM = new File(this.magicUsersFile.getAbsolutePath() + ".rpmsave");
            this.magicUsersFileDEB = new File(this.magicUsersFile.getAbsolutePath() + ".dpkg-remove");
            this.usersFile = ConfigFileConstants.getFile((int)ConfigFileConstants.USERS_CONF_FILE_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getOrder() {
        return 12;
    }

    @Override
    public String getDescription() {
        return "Moves security roles from magic-users.properties into the users.xml file: HZN-871";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        if (!this.canRun()) {
            return;
        }
        try {
            File[] files;
            for (File file : files = new File[]{this.magicUsersFile, this.magicUsersFileRPM, this.magicUsersFileDEB, this.usersFile}) {
                if (!file.exists()) continue;
                this.log("Backing up %s\n", file);
                this.zipFile(file);
            }
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't backup files because " + e.getMessage());
        }
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
        if (!this.canRun()) {
            return;
        }
        if (this.magicUsersFile.exists()) {
            this.log("Removing original config file %s\n", this.magicUsersFile);
            FileUtils.deleteQuietly((File)this.magicUsersFile);
        }
        if (this.magicUsersFileRPM.exists()) {
            this.log("Removing config file (RPM version) %s\n", this.magicUsersFileRPM);
            FileUtils.deleteQuietly((File)this.magicUsersFileRPM);
        }
        if (this.magicUsersFileDEB.exists()) {
            this.log("Removing config file (DEB version) %s\n", this.magicUsersFileDEB);
            FileUtils.deleteQuietly((File)this.magicUsersFileDEB);
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        File[] files;
        if (!this.canRun()) {
            return;
        }
        for (File file : files = new File[]{this.magicUsersFile, this.magicUsersFileRPM, this.magicUsersFileDEB, this.usersFile}) {
            File zip = new File(file.getAbsolutePath() + ".zip");
            if (!zip.exists()) continue;
            this.log("Restoring backup %s\n", zip);
            FileUtils.deleteQuietly((File)file);
            this.unzipFile(zip, zip.getParentFile());
        }
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        if (!this.canRun()) {
            this.log("Error: ignoring the execution of the task because the file magic-users.properties was not found. Maybe the task was already successfully executed before.\n", new Object[0]);
            return;
        }
        boolean foundReadOnlyTag = false;
        ArrayList<String[]> readOnlyUsers = new ArrayList<String[]>();
        try {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new FileReader(this.usersFile)));
            Document doc = parser.getDocument();
            NodeList users = doc.getElementsByTagName("user");
            for (int i = 0; i < users.getLength(); ++i) {
                Node readOnly;
                String[] userName = null;
                Node user = users.item(i);
                NamedNodeMap attributes = user.getAttributes();
                NodeList userChildren = user.getChildNodes();
                for (int j = 0; j < userChildren.getLength(); ++j) {
                    Node child = userChildren.item(j);
                    if (!"user-id".equals(child.getLocalName())) continue;
                    userName = child.getTextContent();
                    break;
                }
                if ((readOnly = attributes.getNamedItem("read-only")) == null) continue;
                if (userName == null) {
                    this.log("Warning: found a read-only tag but unable to determine username: " + String.valueOf(user) + "\n", new Object[0]);
                    continue;
                }
                foundReadOnlyTag = true;
                boolean isReadOnly = Boolean.valueOf(readOnly.getTextContent());
                if (!isReadOnly) continue;
                this.log((String)userName + " is read-only\n", new Object[0]);
                readOnlyUsers.add(userName);
            }
            if (foundReadOnlyTag) {
                this.log("Removing the read-only flags from users.xml\n", new Object[0]);
                String content = new String(Files.readAllBytes(this.usersFile.toPath()), StandardCharsets.UTF_8);
                content = content.replaceAll("\\s+read-only=\".+\"", "");
                Files.write(this.usersFile.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't fix configuration because " + e.getMessage(), e);
        }
        this.log("Moving security roles into users.xml...\n", new Object[0]);
        try {
            String[] configuredUsers;
            UserFactory.init();
            UserManager userManager = UserFactory.getInstance();
            ArrayList<OnmsUser> users = new ArrayList<OnmsUser>();
            for (String userName : userManager.getUserNames()) {
                this.log("Loading configured user: %s...\n", userName);
                users.add(userManager.getOnmsUser(userName));
            }
            Properties properties = new Properties();
            if (this.magicUsersFile.exists()) {
                properties.load(new FileInputStream(this.magicUsersFile));
            } else if (this.magicUsersFileRPM.exists()) {
                properties.load(new FileInputStream(this.magicUsersFileRPM));
            } else if (this.magicUsersFileDEB.exists()) {
                properties.load(new FileInputStream(this.magicUsersFileDEB));
            } else {
                throw new IllegalArgumentException("Can't find magic-users.properties, or any RPM/DEB backup of it");
            }
            for (String user : configuredUsers = BundleLists.parseBundleList((String)properties.getProperty("users"))) {
                String username = properties.getProperty("user." + user + ".username");
                String password = properties.getProperty("user." + user + ".password");
                OnmsUser newUser = new OnmsUser();
                newUser.setUsername(username);
                newUser.setFullName(user);
                newUser.setComments("This is a system user, do not delete");
                newUser.setPassword(userManager.encryptedPassword(password, true));
                newUser.setPasswordSalted(Boolean.valueOf(true));
                users.add(0, newUser);
            }
            String[] configuredRoles = BundleLists.parseBundleList((String)properties.getProperty("roles"));
            for (String role : configuredRoles) {
                String userList = properties.getProperty("role." + role + ".users");
                if (userList == null) {
                    this.log("Warning: Role configuration for '%s' does not have 'users' parameter.  Expecting a 'role.%s.users' property. The role will not be usable.\n", role, role);
                    continue;
                }
                String[] authUsers = BundleLists.parseBundleList((String)userList);
                boolean notInDefaultGroup = "true".equals(properties.getProperty("role." + role + ".notInDefaultGroup"));
                String securityRole = "ROLE_" + role.toUpperCase();
                ArrayList<String> customRoles = new ArrayList<String>();
                for (String username : authUsers) {
                    OnmsUser onmsUser = this.getUser(users, username);
                    if (onmsUser == null) {
                        this.log("Warning: User %s doesn't exist on users.xml, Ignoring.\n", username);
                        continue;
                    }
                    this.addRole(onmsUser, securityRole);
                    if (!notInDefaultGroup && !securityRole.equals("ROLE_ADMIN")) {
                        this.addRole(onmsUser, "ROLE_USER");
                    }
                    if (Authentication.isValidRole((String)securityRole)) continue;
                    this.log("Warning: %s is a custom role.\n", securityRole);
                    customRoles.add(role);
                }
                if (customRoles.isEmpty()) continue;
                String roleList = StringUtils.join(customRoles, (char)',');
                this.log("Creating %s with roles: %s\n", "security-roles.properties", roleList);
                Properties p = new Properties();
                p.put("roles", roleList);
                File configFile = new File(ConfigFileConstants.getHome(), "etc" + File.separator + "security-roles.properties");
                p.store(new FileWriter(configFile), "Custom Roles");
            }
            for (OnmsUser user : users) {
                if (readOnlyUsers.contains(user.getUsername())) {
                    this.addRole(user, "ROLE_READONLY");
                    if (!user.getRoles().contains("ROLE_USER")) {
                        this.addRole(user, "ROLE_USER");
                    }
                }
                userManager.save(user);
            }
        }
        catch (Throwable e) {
            throw new OnmsUpgradeException("Can't fix configuration because " + e.getMessage(), e);
        }
    }

    private OnmsUser getUser(List<OnmsUser> users, String userName) {
        for (OnmsUser user : users) {
            if (!user.getUsername().equals(userName)) continue;
            return user;
        }
        return null;
    }

    private void addRole(OnmsUser onmsUser, String securityRole) {
        this.log("Adding role %s to user %s\n", securityRole, onmsUser.getUsername());
        onmsUser.addRole(securityRole);
    }

    private boolean canRun() {
        boolean defaultOk = this.magicUsersFile != null && this.magicUsersFile.exists();
        boolean rpmOk = this.magicUsersFileRPM != null && this.magicUsersFileRPM.exists();
        boolean debOk = this.magicUsersFileDEB != null && this.magicUsersFileDEB.exists();
        return defaultOk || rpmOk || debOk;
    }
}

