/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;

public class JettyConfigMigratorOffline
extends AbstractOnmsUpgrade {
    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    public String getDescription() {
        return "Adds jetty.xml if necessary: NMS-6629";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        String jettySSL = this.getMainProperties().getProperty("org.opennms.netmgt.jetty.https-port", null);
        String jettyAJP = this.getMainProperties().getProperty("org.opennms.netmgt.jetty.ajp-port", null);
        boolean sslWasFixed = false;
        boolean ajpWasFixed = false;
        try {
            this.log("SSL Enabled ? %s\n", jettySSL != null);
            this.log("AJP Enabled ? %s\n", jettyAJP != null);
            if (jettySSL != null || jettyAJP != null) {
                File jettyXmlExample = new File(this.getHomeDirectory(), "etc" + File.separator + "examples" + File.separator + "jetty.xml");
                File jettyXml = new File(this.getHomeDirectory(), "etc" + File.separator + "jetty.xml");
                if (!jettyXml.exists() && !jettyXmlExample.exists()) {
                    throw new FileNotFoundException("The required file doesn't exist: " + String.valueOf(jettyXmlExample));
                }
                if (!jettyXml.exists()) {
                    this.log("Copying %s into %s\n", jettyXmlExample, jettyXml);
                    FileUtils.copyFile((File)jettyXmlExample, (File)jettyXml);
                }
                this.log("Creating %s\n", jettyXml);
                File tempFile = new File(String.valueOf(jettyXml.getAbsoluteFile()) + ".tmp");
                FileWriter w = new FileWriter(tempFile);
                LineIterator it = FileUtils.lineIterator((File)jettyXmlExample);
                boolean startSsl = false;
                boolean startAjp = false;
                while (it.hasNext()) {
                    String line = it.next();
                    if (startAjp) {
                        if (line.matches("^\\s+[<][!]--\\s*$")) continue;
                        if (line.matches("^\\s+--[>]\\s*$")) {
                            startAjp = false;
                            ajpWasFixed = true;
                            continue;
                        }
                    }
                    if (startSsl) {
                        if (line.matches("^\\s+[<][!]--\\s*$")) continue;
                        if (line.matches("^\\s+--[>]\\s*$")) {
                            startSsl = false;
                            sslWasFixed = true;
                            continue;
                        }
                    }
                    w.write(line + "\n");
                    if (!startAjp && line.contains("<!-- Add AJP support -->") && jettyAJP != null) {
                        startAjp = true;
                        this.log("Enabling AjpConnector\n", new Object[0]);
                    }
                    if (startSsl || !line.contains("<!-- Add HTTPS support -->") || jettySSL == null) continue;
                    startSsl = true;
                    this.log("Enabling SslSelectChannelConnector\n", new Object[0]);
                }
                LineIterator.closeQuietly((LineIterator)it);
                w.close();
                FileUtils.copyFile((File)tempFile, (File)jettyXml);
                FileUtils.deleteQuietly((File)tempFile);
            } else {
                this.log("Neither SSL nor AJP are enabled.\n", new Object[0]);
            }
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't fix Jetty configuration because " + e.getMessage(), e);
        }
        if (jettyAJP != null && !ajpWasFixed) {
            throw new OnmsUpgradeException("Can't enable APJ, please manually edit jetty.xml and uncomment the section where org.eclipse.jetty.ajp.Ajp13SocketConnector is defined.");
        }
        if (jettySSL != null && !sslWasFixed) {
            throw new OnmsUpgradeException("Can't enable SSL, please manually edit jetty.xml and uncomment the section where org.eclipse.jetty.server.ssl.SslSelectChannelConnector is defined.");
        }
    }
}

