/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DiscoveryConfigurationMigratorOffline
extends AbstractOnmsUpgrade {
    private File m_configFile = Paths.get(ConfigFileConstants.getHome(), "etc", "discovery-configuration.xml").toFile();
    private File m_backupFile;

    @Override
    public int getOrder() {
        return 11;
    }

    @Override
    public String getDescription() {
        return "Removes the 'threads' attribute from discovery-configuration.xml. See HZN-599.";
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        this.log("Backing up discovery-configuration.xml\n", new Object[0]);
        this.m_backupFile = this.zipFile(this.m_configFile);
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        StringWriter out = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(this.m_configFile);
            NodeList found = doc.getElementsByTagName("discovery-configuration");
            if (found.getLength() != 1 || !(found.item(0) instanceof Element)) {
                throw new OnmsUpgradeException("Unsure how to handle XML node(s): " + String.valueOf(found));
            }
            Element el = (Element)found.item(0);
            el.removeAttribute("threads");
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            tf.setOutputProperty("indent", "yes");
            out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            FileUtils.write((File)this.m_configFile, (CharSequence)((Object)out).toString());
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            try {
                throw new OnmsUpgradeException("Failed to upgrade discovery-configuration.xml", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)out);
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
        if (this.m_backupFile.exists()) {
            this.log("Removing backup %s\n", this.m_backupFile);
            FileUtils.deleteQuietly((File)this.m_backupFile);
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        if (!this.m_backupFile.exists()) {
            throw new OnmsUpgradeException(String.format("Backup %s not found. Can't rollback.", this.m_backupFile));
        }
        this.log("Unzipping backup %s to %s\n", this.m_backupFile, this.m_configFile.getParentFile());
        this.unzipFile(this.m_backupFile, this.m_configFile.getParentFile());
        this.log("Rollback succesful. The backup file %s will be kept.\n", this.m_backupFile);
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }
}

