/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.DefaultDataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.DatacollectionConfig;
import org.opennms.netmgt.config.datacollection.DatacollectionGroup;
import org.opennms.netmgt.config.datacollection.IncludeCollection;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DataCollectionConfigMigrator17Offline
extends AbstractOnmsUpgrade {
    private File sourceFile;
    private File backupFile;
    private Pattern pattern = Pattern.compile("instance '([^']+)' invalid in mibObj definition for OID '.+' in collection '([^']+)'");
    private Map<File, DatacollectionGroup> dataCollectionGroupMap = new HashMap<File, DatacollectionGroup>();

    public DataCollectionConfigMigrator17Offline() throws OnmsUpgradeException {
        this.sourceFile = Paths.get(ConfigFileConstants.getHome(), "etc", "datacollection-config.xml").toFile();
        this.backupFile = new File(this.sourceFile.getAbsolutePath() + ".zip");
    }

    @Override
    public String getDescription() {
        return "Fixes the missing resource types on datacollection-config.xml. See NMS-7816.";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public int getOrder() {
        return 9;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        this.log("Backing up %s\n", this.sourceFile);
        this.zipFile(this.sourceFile);
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        this.log("Patching %s\n", this.sourceFile);
        while (!this.isConfigValid()) {
            this.log("A missing resource-type has been added, trying again\n", new Object[0]);
        }
    }

    private boolean isConfigValid() throws OnmsUpgradeException {
        block6: {
            File configDirectory = new File(this.sourceFile.getParentFile().getAbsolutePath(), "datacollection");
            try {
                DefaultDataCollectionConfigDao dao = new DefaultDataCollectionConfigDao();
                dao.setConfigDirectory(configDirectory.getAbsolutePath());
                dao.setConfigResource((Resource)new FileSystemResource(this.sourceFile));
                dao.setReloadCheckInterval(new Long(0L));
                dao.afterPropertiesSet();
            }
            catch (IllegalArgumentException e) {
                this.log("Found a problem: %s\n", e.getMessage());
                Matcher m = this.pattern.matcher(e.getMessage());
                if (!m.find()) break block6;
                try {
                    Iterator paths = Files.list(configDirectory.toPath()).filter(f -> f.getFileName().toString().toLowerCase().endsWith(".xml")).iterator();
                    while (paths.hasNext()) {
                        String group = this.getGroupForResourceType(((Path)paths.next()).toFile(), m.group(1));
                        if (group == null) continue;
                        this.updateDataCollectionConfig(m.group(2), group);
                        return false;
                    }
                }
                catch (Exception ex) {
                    throw new OnmsUpgradeException("Can't get datacollection-group files", ex);
                }
            }
            catch (Exception e) {
                throw new OnmsUpgradeException("Can't process " + String.valueOf(this.sourceFile), e);
            }
        }
        return true;
    }

    private void updateDataCollectionConfig(String snmpCollection, String dataCollectionGroup) throws OnmsUpgradeException {
        DatacollectionConfig config = (DatacollectionConfig)JaxbUtils.unmarshal(DatacollectionConfig.class, (File)this.sourceFile);
        if (config != null) {
            this.log("Adding datacollection-group %s to snmp-collection %s", dataCollectionGroup, snmpCollection);
            IncludeCollection ic = new IncludeCollection();
            ic.setDataCollectionGroup(dataCollectionGroup);
            config.getSnmpCollections().stream().filter(s -> s.getName().equals(snmpCollection)).findFirst().get().addIncludeCollection(ic);
            try {
                JaxbUtils.marshal((Object)config, (Writer)new FileWriter(this.sourceFile));
            }
            catch (IOException e) {
                throw new OnmsUpgradeException("Can't update " + String.valueOf(this.sourceFile), e);
            }
        }
    }

    private String getGroupForResourceType(File configFile, String resourceType) {
        DatacollectionGroup g = this.getDataCollectionGroup(configFile);
        if (g.getResourceTypes().stream().filter(r -> r.getName().equals(resourceType)).count() > 0L) {
            return g.getName();
        }
        return null;
    }

    private DatacollectionGroup getDataCollectionGroup(File configFile) {
        if (this.dataCollectionGroupMap.get(configFile) == null) {
            this.log("Parsing datacollection-group %s\n", configFile.getAbsolutePath());
            DatacollectionGroup grp = (DatacollectionGroup)JaxbUtils.unmarshal(DatacollectionGroup.class, (File)configFile);
            this.dataCollectionGroupMap.put(configFile, grp);
        }
        return this.dataCollectionGroupMap.get(configFile);
    }

    @Override
    public void postExecute() {
        if (this.backupFile.exists()) {
            this.log("Removing backup %s\n", this.backupFile);
            FileUtils.deleteQuietly((File)this.backupFile);
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        if (!this.backupFile.exists()) {
            throw new OnmsUpgradeException(String.format("Backup %s not found. Can't rollback.", this.backupFile));
        }
        this.log("Unziping backup %s to %s\n", this.backupFile, this.sourceFile.getParentFile());
        this.unzipFile(this.backupFile, this.sourceFile.getParentFile());
        this.log("Rollback succesful. The backup file %s will be kept.\n", this.backupFile);
    }
}

