/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;

public class ClearKarafCacheMigratorOffline
extends AbstractOnmsUpgrade {
    private final Path opennmsDataPath = Path.of(ConfigFileConstants.getHome(), new String[0]).resolve("data");

    @Override
    public int getOrder() {
        return 16;
    }

    @Override
    public String getDescription() {
        return String.format("Clears the Karaf cache in '%s', see NMS-16226", this.opennmsDataPath);
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        Path historyFilePath = this.opennmsDataPath.resolve("history.txt");
        try {
            Files.walk(this.opennmsDataPath, new FileVisitOption[0]).filter(path -> !path.equals(historyFilePath) && !path.equals(this.opennmsDataPath)).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            throw new OnmsUpgradeException(String.format("Error pruning Karaf's data directory '%s'.", this.opennmsDataPath), e);
        }
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public boolean runOnlyOnce() {
        return false;
    }
}

