/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.datablock;

import java.util.ArrayList;
import java.util.List;
import org.opennms.reporting.datablock.Interface;
import org.opennms.reporting.datablock.Service;
import org.opennms.reporting.datablock.StandardNamedObject;

public class Node
extends StandardNamedObject {
    private List<Interface> m_interfaces = new ArrayList<Interface>();
    private boolean m_hasOutage = false;
    long m_downTime;
    long m_totalWindow;
    long m_busDownTime;
    long m_busTotalWindow;
    double m_percentAvail;
    double m_percentBusAvail;
    int m_serviceCount;
    int m_nodeid = -1;

    public Node() {
        this.m_interfaces = new ArrayList<Interface>();
        this.m_downTime = 0L;
    }

    public Node(String name, int id) {
        this.m_nodeid = id;
        this.setName(name);
        this.m_interfaces = new ArrayList<Interface>();
        this.m_downTime = 0L;
    }

    public Node(String name, List<Interface> interfaces, int id) {
        this.m_nodeid = id;
        this.setName(name);
        this.m_interfaces = interfaces;
        this.m_downTime = 0L;
    }

    public Node(List<Interface> interfaces) {
        this.m_interfaces = interfaces;
        this.m_downTime = 0L;
    }

    public boolean hasOutages() {
        return this.m_hasOutage;
    }

    public long getDownTime() {
        return this.m_downTime;
    }

    public long getBusDownTime() {
        return this.m_busDownTime;
    }

    public double getPercentAvail() {
        return this.m_percentAvail;
    }

    public double getPercentBusAvail() {
        return this.m_percentBusAvail;
    }

    public int getServiceCount() {
        int count = 0;
        for (Interface intf : this.m_interfaces) {
            if (intf == null) continue;
            count += intf.getServiceCount();
        }
        this.m_serviceCount = count;
        return count;
    }

    public int getInterfaceCount() {
        if (this.m_interfaces != null) {
            return this.m_interfaces.size();
        }
        return 0;
    }

    public long getBusTotalWindow() {
        return this.m_busTotalWindow;
    }

    public long getTotalWindow() {
        return this.m_totalWindow;
    }

    public List<Interface> getInterfaces() {
        return this.m_interfaces;
    }

    public int getNodeID() {
        return this.m_nodeid;
    }

    public int getServiceAffectCount() {
        int count = 0;
        for (Interface intf : this.m_interfaces) {
            if (intf == null) continue;
            count += intf.getServiceAffectCount();
        }
        return count;
    }

    public void addInterface(String intfname) {
        if (intfname == null) {
            return;
        }
        int ndx = this.m_interfaces.indexOf(InterfaceComparator.make(intfname));
        if (ndx == -1) {
            Interface intf = new Interface(intfname);
            this.m_interfaces.add(intf);
        }
    }

    public void addInterface(String intfname, String service) {
        if (intfname == null) {
            return;
        }
        int ndx = this.m_interfaces.indexOf(InterfaceComparator.make(intfname));
        if (ndx != -1) {
            Interface intf = this.m_interfaces.get(ndx);
            if (service != null) {
                intf.addService(service);
            }
            return;
        }
        Interface intf = new Interface(intfname);
        if (service != null) {
            intf.addService(service);
        }
        this.m_interfaces.add(intf);
    }

    public void addInterface(String intfname, String service, long lost) {
        int ndx = this.m_interfaces.indexOf(InterfaceComparator.make(intfname));
        if (ndx != -1) {
            Interface intf = this.m_interfaces.get(ndx);
            if (service != null) {
                intf.addService(service, lost);
                this.m_hasOutage = true;
            }
            return;
        }
        Interface intf = new Interface(intfname);
        if (service != null) {
            intf.addService(service, lost);
            this.m_hasOutage = true;
        }
        this.m_interfaces.add(intf);
    }

    public Interface getInterface(String intfname) {
        if (intfname == null) {
            return null;
        }
        int ndx = this.m_interfaces.indexOf(InterfaceComparator.make(intfname));
        if (ndx != -1) {
            Interface intf = this.m_interfaces.get(ndx);
            return intf;
        }
        return null;
    }

    public void addInterface(String intfname, String service, long lost, long regained) {
        if (intfname == null) {
            return;
        }
        int ndx = this.m_interfaces.indexOf(InterfaceComparator.make(intfname));
        if (ndx != -1) {
            Interface intf = this.m_interfaces.get(ndx);
            intf.addService(service, lost, regained);
            this.m_hasOutage = true;
            return;
        }
        Interface intf = new Interface(intfname);
        if (service != null) {
            intf.addService(service, lost, regained);
            this.m_hasOutage = true;
        }
        this.m_interfaces.add(intf);
    }

    public double getPercentAvail(long endTime, long rollingWindow) {
        double percent = 0.0;
        long outage = 0L;
        int serviceCount = 0;
        if (this.m_interfaces != null && this.m_interfaces.size() > 0) {
            for (Interface intf : this.m_interfaces) {
                if (intf == null) continue;
                long down = intf.getDownTime(endTime, rollingWindow);
                if (down > 0L) {
                    outage += down;
                }
                serviceCount += intf.getServiceCount();
            }
        }
        if (serviceCount > 0) {
            this.m_downTime = outage;
            this.m_totalWindow = rollingWindow * (long)serviceCount;
            this.m_serviceCount = serviceCount;
            double denom = (double)(rollingWindow * (long)serviceCount) * 1.0;
            double num = 1.0 * (double)outage;
            percent = 100.0 * (1.0 - num / denom);
        } else {
            percent = 100.0;
        }
        this.m_percentAvail = percent;
        return percent;
    }

    public long getOutage(long endTime, long rollingWindow) {
        long outage = 0L;
        int serviceCount = 0;
        for (Interface intf : this.m_interfaces) {
            if (intf == null) continue;
            long down = intf.getDownTime(endTime, rollingWindow);
            if (down > 0L) {
                outage += down;
            }
            serviceCount += intf.getServiceCount();
        }
        if (serviceCount > 0) {
            this.m_serviceCount = serviceCount;
        }
        return outage;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        String nl = System.getProperty("line.separator");
        retVal.append(nl).append(nl).append("Nodeid : ").append(this.getName()).append(nl).append("Interfaces");
        for (Interface intf : this.m_interfaces) {
            if (intf == null) continue;
            retVal.append(nl).append("\t\t").append(intf.getName());
            List<Service> services = intf.getServices();
            for (Service service : services) {
                retVal.append(nl).append("\t\t\t\t").append(service.getName());
                if (service == null) continue;
                retVal.append(nl).append("\t\t\t\t\t").append(service.getOutages());
            }
        }
        return retVal.toString();
    }

    private static class InterfaceComparator {
        private String m_intfname;

        private InterfaceComparator(String intf) {
            this.m_intfname = intf;
        }

        static InterfaceComparator make(String name) {
            return new InterfaceComparator(name);
        }

        static InterfaceComparator make(Service svc) {
            return new InterfaceComparator(svc.getName());
        }

        public boolean equals(Object o) {
            boolean rc = false;
            if (o != null) {
                if (o == this) {
                    rc = true;
                } else if (o instanceof Interface) {
                    rc = this.m_intfname.equals(((Interface)o).getName());
                } else if (o instanceof String) {
                    rc = this.m_intfname.equals(o);
                }
            }
            return rc;
        }
    }
}

