/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.Callable;
import org.opennms.core.logging.Logging;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.ReportCatalogEntry;
import org.opennms.reporting.availability.AvailabilityCalculationException;
import org.opennms.reporting.availability.AvailabilityCalculator;
import org.opennms.reporting.availability.AvailabilityData;
import org.opennms.reporting.availability.Categories;
import org.opennms.reporting.availability.Created;
import org.opennms.reporting.availability.Report;
import org.opennms.reporting.availability.ViewInfo;
import org.opennms.reporting.core.svclayer.ReportStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailabilityCalculatorImpl
implements AvailabilityCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(AvailabilityCalculatorImpl.class);
    private static final String LOG4J_CATEGORY = "reports";
    public static String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private Date m_periodEndDate;
    private String m_monthFormat;
    private String m_reportFormat;
    private String m_logoURL;
    private String m_baseDir;
    private String m_outputFileName;
    private String m_author;
    private String m_categoryName;
    private Report m_report = null;
    private ReportStoreService m_reportStoreService;
    private AvailabilityData m_availabilityData;

    public AvailabilityCalculatorImpl() {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            @Override
            public void run() {
                AvailabilityCalculatorImpl.this.m_report = new Report();
                AvailabilityCalculatorImpl.this.m_report.setAuthor(AvailabilityCalculatorImpl.this.m_author);
                GregorianCalendar today = new GregorianCalendar();
                int day = today.get(5);
                int year = today.get(1);
                String month = months[today.get(2)];
                int hour = today.get(10);
                int minute = today.get(12);
                int second = today.get(13);
                Created created = new Created();
                created.setDay(day);
                created.setHour(hour);
                created.setMin(minute);
                created.setMonth(month);
                created.setSec(second);
                created.setYear(year);
                created.setContent(new BigDecimal(today.getTime().getTime()));
                AvailabilityCalculatorImpl.this.m_report.setCreated(created);
            }
        });
    }

    @Override
    public void calculate() throws AvailabilityCalculationException {
        try {
            Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    LOG.debug("Calculation Started");
                    LOG.debug("periodEndDate: {}", (Object)AvailabilityCalculatorImpl.this.m_periodEndDate);
                    AvailabilityCalculatorImpl.this.m_report.setLogo(AvailabilityCalculatorImpl.this.m_logoURL);
                    LOG.debug("logoURL: {}", (Object)AvailabilityCalculatorImpl.this.m_logoURL);
                    ViewInfo viewInfo = new ViewInfo();
                    AvailabilityCalculatorImpl.this.m_report.setViewInfo(viewInfo);
                    Categories categories = new Categories();
                    AvailabilityCalculatorImpl.this.m_report.setCategories(categories);
                    try {
                        LOG.debug("Populating datastructures and calculating availability");
                        LOG.debug("category: {}", (Object)AvailabilityCalculatorImpl.this.m_categoryName);
                        LOG.debug("monthFormat: {}", (Object)AvailabilityCalculatorImpl.this.m_monthFormat);
                        LOG.debug("reportFormat: {}", (Object)AvailabilityCalculatorImpl.this.m_reportFormat);
                        AvailabilityCalculatorImpl.this.m_availabilityData.fillReport(AvailabilityCalculatorImpl.this.m_categoryName, AvailabilityCalculatorImpl.this.m_report, AvailabilityCalculatorImpl.this.m_reportFormat, AvailabilityCalculatorImpl.this.m_monthFormat, AvailabilityCalculatorImpl.this.m_periodEndDate);
                    }
                    catch (Exception e) {
                        LOG.error("An error occurred while calculating availability.", (Throwable)e);
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new AvailabilityCalculationException(e);
        }
    }

    @Override
    public String writeXML() throws AvailabilityCalculationException {
        try {
            LOG.debug("Writing the XML");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
            String catFileName = this.m_categoryName.replace(' ', '-');
            this.m_outputFileName = this.m_baseDir + catFileName + "-" + this.m_monthFormat + fmt.format(this.m_periodEndDate) + ".xml";
            LOG.debug("Report Store XML file: {}", (Object)this.m_outputFileName);
            File reportFile = new File(this.m_outputFileName);
            this.marshal(reportFile);
        }
        catch (AvailabilityCalculationException e) {
            LOG.error("Unable to marshal report as XML");
            throw new AvailabilityCalculationException(e);
        }
        return this.m_outputFileName;
    }

    @Override
    public void writeXML(String outputFileName) throws AvailabilityCalculationException {
        try {
            LOG.debug("Writing the XML");
            this.m_outputFileName = outputFileName;
            LOG.debug("Report Store XML file: {}", (Object)this.m_outputFileName);
            File reportFile = new File(this.m_baseDir, this.m_outputFileName);
            this.marshal(reportFile);
        }
        catch (AvailabilityCalculationException e) {
            LOG.error("Unable to marshal report as XML");
            throw new AvailabilityCalculationException(e);
        }
    }

    @Override
    public String writeLocateableXML(String id) throws AvailabilityCalculationException {
        try {
            LOG.debug("Writing the XML");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
            String catFileName = this.m_categoryName.replace(' ', '-');
            this.m_outputFileName = catFileName + "-" + this.m_monthFormat + fmt.format(this.m_periodEndDate) + ".xml";
            LOG.debug("Report Store XML file: {}", (Object)this.m_outputFileName);
            File reportFile = new File(this.m_baseDir, this.m_outputFileName);
            this.marshal(reportFile);
            ReportCatalogEntry catalogEntry = new ReportCatalogEntry();
            catalogEntry.setReportId(id);
            catalogEntry.setTitle(this.m_monthFormat + " " + this.m_categoryName);
            catalogEntry.setLocation(reportFile.getAbsolutePath());
            catalogEntry.setDate(new Date());
            this.m_reportStoreService.save(catalogEntry);
        }
        catch (AvailabilityCalculationException e) {
            LOG.error("Unable to marshal report as XML");
            throw new AvailabilityCalculationException(e);
        }
        return this.m_outputFileName;
    }

    @Override
    public void writeXML(final OutputStream outputStream) throws AvailabilityCalculationException {
        try {
            Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        LOG.debug("Writing the XML");
                        AvailabilityCalculatorImpl.this.marshal(outputStream);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to write XML", (Throwable)e);
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new AvailabilityCalculationException("Failed to write XML", e);
        }
    }

    @Override
    public void marshal(final File outputFile) throws AvailabilityCalculationException {
        try {
            Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8);
                        JaxbUtils.marshal((Object)AvailabilityCalculatorImpl.this.m_report, (Writer)fileWriter);
                        LOG.debug("The xml marshalled from the JAXB classes is saved in {}", (Object)outputFile.getAbsoluteFile());
                        ((Writer)fileWriter).close();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to write marshal " + String.valueOf(outputFile), (Throwable)e);
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new AvailabilityCalculationException("Failed to marshal " + String.valueOf(outputFile), e);
        }
    }

    private void marshal(final OutputStream outputStream) throws AvailabilityCalculationException {
        try {
            Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                        JaxbUtils.marshal((Object)AvailabilityCalculatorImpl.this.m_report, (Writer)writer);
                        LOG.debug("The xml marshalled from the JAXB classes has been written to the output stream");
                        writer.flush();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to write to output.", (Throwable)e);
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new AvailabilityCalculationException("Failed to write to output.", e);
        }
    }

    @Override
    public String getLogoURL() {
        return this.m_logoURL;
    }

    @Override
    public void setLogoURL(String logoURL) {
        this.m_logoURL = logoURL;
    }

    @Override
    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    @Override
    public void setOutputFileName(String outputFileName) {
        this.m_outputFileName = outputFileName;
    }

    @Override
    public String getAuthor() {
        return this.m_author;
    }

    @Override
    public void setAuthor(String author) {
        this.m_author = author;
    }

    @Override
    public String getCategoryName() {
        return this.m_categoryName;
    }

    @Override
    public void setCategoryName(String categoryName) {
        this.m_categoryName = categoryName;
    }

    @Override
    public String getMonthFormat() {
        return this.m_monthFormat;
    }

    @Override
    public void setMonthFormat(String monthFormat) {
        this.m_monthFormat = monthFormat;
    }

    @Override
    public String getReportFormat() {
        return this.m_reportFormat;
    }

    @Override
    public void setReportFormat(String reportFormat) {
        this.m_reportFormat = reportFormat;
    }

    @Override
    public Report getReport() {
        return this.m_report;
    }

    @Override
    public Date getPeriodEndDate() {
        return this.m_periodEndDate;
    }

    @Override
    public void setPeriodEndDate(Date periodEndDate) {
        this.m_periodEndDate = periodEndDate;
    }

    @Override
    public void setReportStoreService(ReportStoreService reportStoreService) {
        this.m_reportStoreService = reportStoreService;
    }

    @Override
    public String getBaseDir() {
        return this.m_baseDir;
    }

    @Override
    public void setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
    }

    @Override
    public void setAvailabilityData(AvailabilityData availabilityData) {
        this.m_availabilityData = availabilityData;
    }
}

