/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.core.logging.Logging;
import org.opennms.reporting.availability.CalendarTableBuilder;
import org.opennms.reporting.availability.CatSections;
import org.opennms.reporting.availability.Categories;
import org.opennms.reporting.availability.Category;
import org.opennms.reporting.availability.ClassicTable;
import org.opennms.reporting.availability.Col;
import org.opennms.reporting.availability.Report;
import org.opennms.reporting.availability.Row;
import org.opennms.reporting.availability.Rows;
import org.opennms.reporting.availability.Section;
import org.opennms.reporting.availability.Value;
import org.opennms.reporting.datablock.IfService;
import org.opennms.reporting.datablock.Interface;
import org.opennms.reporting.datablock.Node;
import org.opennms.reporting.datablock.OutageSince;
import org.opennms.reporting.datablock.OutageSvcTimesList;
import org.opennms.reporting.datablock.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailCalculations {
    private static final Logger LOG = LoggerFactory.getLogger(AvailCalculations.class);
    private static final String LOG4J_CATEGORY = "reports";
    private static Report m_report = null;
    private Map<String, Map<IfService, OutageSvcTimesList>> m_services = null;
    private long m_endLastMonthTime;
    private int m_daysInLastMonth;
    private static final long ROLLING_WINDOW = 86400000L;
    private static final int THIRTY = 30;
    private static final int NMONTHS = 12;
    private List<Node> m_nodes;
    private List<String> m_monitoredServices;
    private int m_sectionIndex;

    public AvailCalculations(final List<Node> nodes, final long endTime, final long lastMonthEndTime, final List<String> monitoredServices, final Report report, final Map<Double, List<String>> offenders, final double warning, final double normal, final String comments, final String name, final String format, final String monthFormat, final int catIndex, final int sectionIndex) {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            @Override
            public void run() {
                AvailCalculations.this.m_sectionIndex = sectionIndex;
                Category category = new Category();
                category.setWarning(warning);
                category.setNormal(normal);
                category.setCatComments(comments);
                category.setCatName(name);
                category.setCatIndex(catIndex);
                category.setNodeCount(nodes.size());
                int ipaddrCount = 0;
                int serviceCount = 0;
                for (Node tmpNode : nodes) {
                    if (tmpNode == null) continue;
                    ipaddrCount += tmpNode.getInterfaceCount();
                    serviceCount += tmpNode.getServiceCount();
                }
                category.setIpaddrCount(ipaddrCount);
                category.setServiceCount(serviceCount);
                Categories categories = report.getCategories();
                LOG.debug("Inside AvailCalculations using endTime {}", (Object)endTime);
                AvailCalculations.this.m_monitoredServices = monitoredServices;
                AvailCalculations.this.m_endLastMonthTime = lastMonthEndTime;
                AvailCalculations.this.m_daysInLastMonth = AvailCalculations.this.getDaysForMonth(AvailCalculations.this.m_endLastMonthTime);
                m_report = report;
                AvailCalculations.this.m_nodes = nodes;
                LOG.debug("Now computing last 12 months daily availability ");
                String label = "The last 12 Months Availability";
                String descr = "The last 12 Months Availability";
                if (label == null || label.length() == 0) {
                    label = "The last 12 Months Availability";
                }
                if (descr == null || descr.length() == 0) {
                    descr = "The last 12 Months Availability";
                }
                CatSections catSections = new CatSections();
                AvailCalculations.this.lastNMonthsAvailability(12, AvailCalculations.this.m_endLastMonthTime, catSections, label, descr);
                LOG.debug("Computed lastNMonthsAvailability");
                LOG.debug("Now computing last months daily availability ");
                label = "The last Months Daily Availability";
                descr = "Daily Average of svcs monitored and availability of svcs divided by the total svc minutes (last month)";
                if (label == null || label.length() == 0) {
                    label = "The last Months Daily Availability";
                }
                if (descr == null || descr.length() == 0) {
                    descr = "Daily Average of svcs monitored and availability of svcs divided by the total svc minutes (last month)";
                }
                if (monthFormat.equalsIgnoreCase("calendar")) {
                    AvailCalculations.this.lastCalMoDailyAvailability(AvailCalculations.this.m_daysInLastMonth, AvailCalculations.this.m_endLastMonthTime, catSections, label, descr, "LastMonthsDailyAvailability");
                } else {
                    AvailCalculations.this.lastMoDailyAvailability(AvailCalculations.this.m_daysInLastMonth, AvailCalculations.this.m_endLastMonthTime, catSections, label, descr, "LastMonthsDailyAvailability");
                }
                LOG.debug("Computed lastNDaysDailyAvailability");
                LOG.debug("Now computing  month to date daily availability ");
                label = "Month To Date Daily Availability";
                descr = "Daily Average of svc monitored and availability of svcs div by total svc minutes of month frm 1st till date";
                if (label == null || label.length() == 0) {
                    label = "Month To Date Daily Availability";
                }
                if (descr == null || descr.length() == 0) {
                    descr = "Daily Average of svc monitored and availability of svcs div by total svc minutes of month frm 1st till date";
                }
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(new Date(endTime));
                int numDaysInMonth = calendar.get(5);
                if (monthFormat.equalsIgnoreCase("calendar")) {
                    AvailCalculations.this.lastCalMTDDailyAvailability(numDaysInMonth, endTime, catSections, label, descr, "MonthToDateDailyAvailability");
                } else {
                    AvailCalculations.this.lastMTDDailyAvailability(numDaysInMonth, endTime, catSections, label, descr, "MonthToDateDailyAvailability");
                }
                LOG.debug("Computed lastNDaysDailyAvailability");
                LOG.debug("Now computing Last Months Top Offenders ");
                label = "Last Months Top Offenders";
                descr = "This is the list of the worst available devices in the category for the last month";
                if (label == null || label.length() == 0) {
                    label = "Last Months Top Offenders";
                }
                if (descr == null || descr.length() == 0) {
                    descr = "This is the list of the worst available devices in the category for the last month";
                }
                AvailCalculations.this.lastMoTopNOffenders(offenders, catSections, label, descr);
                LOG.debug("Computed lastMoTopNOffenders ");
                if (!format.equals("SVG")) {
                    LOG.debug("Now computing LAST_30_DAYS_DAILY_LABEL ");
                    label = "The last 30 Days Daily Availability";
                    descr = "Daily average of svcs and dvcs monitored and their availability divided by total mins for 30days";
                    if (label == null || label.length() == 0) {
                        label = "The last 30 Days Daily Availability";
                    }
                    if (descr == null || descr.length() == 0) {
                        descr = "Daily average of svcs and dvcs monitored and their availability divided by total mins for 30days";
                    }
                    AvailCalculations.this.lastNDaysDailyAvailability(30, endTime, catSections, label, descr, "Last30DaysDailyAvailability");
                    LOG.debug("Computed lastNDaysDailyAvailability");
                }
                if (!format.equals("SVG")) {
                    LOG.debug("Now computing LAST_30_DAYS_TOTAL_LABEL ");
                    label = "The last 30 Days Total Availability";
                    descr = "Average of svcs monitored and availability of svcs divided by total svc minutes of the last 30 days";
                    if (label == null || label.length() == 0) {
                        label = "The last 30 Days Total Availability";
                    }
                    if (descr == null || descr.length() == 0) {
                        descr = "Average of svcs monitored and availability of svcs divided by total svc minutes of the last 30 days";
                    }
                    AvailCalculations.this.lastNDaysTotalAvailability(30, endTime, catSections, label, descr);
                    LOG.debug("Computed lastNDaysTotalAvailability");
                }
                if (!format.equals("SVG")) {
                    LOG.debug("Now computing LAST_MONTH_TOTAL_LABEL ");
                    label = "The last Months Total Availability";
                    descr = "Average of svcs monitored and availability of svcs divided by the total svc minutes of the month";
                    if (label == null || label.length() == 0) {
                        label = "The last Months Total Availability";
                    }
                    if (descr == null || descr.length() == 0) {
                        descr = "Average of svcs monitored and availability of svcs divided by the total svc minutes of the month";
                    }
                    AvailCalculations.this.lastMoTotalAvailability(AvailCalculations.this.m_daysInLastMonth, AvailCalculations.this.m_endLastMonthTime, catSections, label, descr);
                    LOG.debug("Computed lastNDaysDailyAvailability");
                }
                if (!format.equals("SVG")) {
                    LOG.debug("Now computing LAST_MTD_TOTAL_LABEL ");
                    label = "Month To Date Total Availability";
                    descr = "Average of svc monitored and availability of svcs dividedby total svc minutes of month frm 1st till date";
                    if (label == null || label.length() == 0) {
                        label = "Month To Date Total Availability";
                    }
                    if (descr == null || descr.length() == 0) {
                        descr = "Average of svc monitored and availability of svcs dividedby total svc minutes of month frm 1st till date";
                    }
                    AvailCalculations.this.lastMoTotalAvailability(numDaysInMonth, endTime, catSections, label, descr);
                    LOG.debug("Computed MTDTotalAvailability");
                }
                AvailCalculations.this.m_services = new HashMap<String, Map<IfService, OutageSvcTimesList>>();
                for (Node node : nodes) {
                    if (node == null) continue;
                    for (Interface intf : node.getInterfaces()) {
                        if (intf == null) continue;
                        for (Service svc : intf.getServices()) {
                            OutageSvcTimesList outages;
                            if (svc == null || (outages = svc.getOutages()) == null) continue;
                            IfService ifservice = new IfService(node.getNodeID(), intf.getName(), -1, node.getName(), svc.getName());
                            Map<IfService, OutageSvcTimesList> svcOutages = AvailCalculations.this.m_services.get(svc.getName());
                            if (svcOutages == null) {
                                svcOutages = new HashMap<IfService, OutageSvcTimesList>();
                            }
                            svcOutages.put(ifservice, outages);
                            AvailCalculations.this.m_services.put(svc.getName(), svcOutages);
                        }
                    }
                }
                LOG.debug("Services {}", AvailCalculations.this.m_services);
                AvailCalculations.this.m_nodes = null;
                if (!format.equals("SVG")) {
                    LOG.debug("Now computing LAST_30_DAYS_SVC_AVAIL_LABEL ");
                    label = "The last 30 days Daily Service Availability";
                    descr = "The last 30 days Daily Service Availability is the daily average of services";
                    if (label == null || label.length() == 0) {
                        label = "The last 30 days Daily Service Availability";
                    }
                    if (descr == null || descr.length() == 0) {
                        descr = "The last 30 days Daily Service Availability is the daily average of services";
                    }
                    AvailCalculations.this.lastNDaysDailyServiceAvailability(30, endTime, catSections, label, descr);
                    LOG.debug("Computed lastNDaysDailyServiceAvailability");
                }
                if (!format.equals("SVG")) {
                    LOG.debug("Now computing LAST_MONTH_SVC_AVAIL_LABE");
                    label = "The last Months Daily Service Availability";
                    descr = "The last Months Daily Service Availability is the daily average of services and devices";
                    if (label == null || label.length() == 0) {
                        label = "The last Months Daily Service Availability";
                    }
                    if (descr == null || descr.length() == 0) {
                        descr = "The last Months Daily Service Availability is the daily average of services and devices";
                    }
                    AvailCalculations.this.lastNDaysDailyServiceAvailability(AvailCalculations.this.m_daysInLastMonth, AvailCalculations.this.m_endLastMonthTime, catSections, label, descr);
                    LOG.debug("Computed lastNDaysDailyServiceAvailability");
                }
                if (!format.equals("SVG")) {
                    LOG.debug("Now computing TOP20_SVC_OUTAGES_LABEL");
                    label = "Last Month Top Service Outages for";
                    descr = "Last Month Top Service Outages for";
                    if (label == null || label.length() == 0) {
                        label = "Last Month Top Service Outages for ";
                    }
                    if (descr == null || descr.length() == 0) {
                        descr = "Last Month Top Service Outages for ";
                    }
                    AvailCalculations.this.lastMonTopNServiceOutages(catSections, label, descr);
                    LOG.debug("Computed lastMonTopNServiceOutages");
                }
                AvailCalculations.this.m_services = null;
                category.addCatSections(catSections);
                categories.addCategory(category);
                m_report.setCategories(categories);
                LOG.debug("Leaving AvailCalculations");
            }
        });
    }

    public int getSectionIndex() {
        return this.m_sectionIndex;
    }

    private void lastMonTopNServiceOutages(CatSections catSections, String label, String descr) {
        TreeMap<Long, ArrayList<OutageSince>> treeMap = null;
        for (Map.Entry<String, Map<IfService, OutageSvcTimesList>> serviceEntry : this.m_services.entrySet()) {
            treeMap = new TreeMap<Long, ArrayList<OutageSince>>();
            Map<IfService, OutageSvcTimesList> ifSvcOutageList = serviceEntry.getValue();
            for (Map.Entry<IfService, OutageSvcTimesList> ifserviceEntry : ifSvcOutageList.entrySet()) {
                OutageSvcTimesList outageSvcList;
                if (ifserviceEntry.getKey() == null || (outageSvcList = ifserviceEntry.getValue()) == null) continue;
                long rollingWindow = (long)this.m_daysInLastMonth * 86400000L;
                List<OutageSince> svcOutages = outageSvcList.getServiceOutages(ifserviceEntry.getKey().getNodeName(), this.m_endLastMonthTime, rollingWindow);
                Iterator iterator = svcOutages.iterator();
                while (iterator.hasNext()) {
                    OutageSince outageSince = (OutageSince)iterator.next();
                    if (outageSince == null) continue;
                    long outage = outageSince.getOutage() / 1000L;
                    ArrayList<OutageSince> tmpList = (ArrayList<OutageSince>)treeMap.get(new Long(outage));
                    if (tmpList == null) {
                        tmpList = new ArrayList<OutageSince>();
                    }
                    tmpList.add(outageSince);
                    treeMap.put(new Long(-1L * outage), tmpList);
                }
            }
            LOG.debug("Top 20 service outages from the list {}", treeMap);
            int top20Count = 0;
            Rows rows = new Rows();
            SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            block3: for (List list : treeMap.values()) {
                for (OutageSince outageSince : list) {
                    ++top20Count;
                    String nodeName = outageSince.getNodeName();
                    Value nodeValue = new Value();
                    nodeValue.setContent(nodeName);
                    nodeValue.setType("title");
                    Value value = new Value();
                    long outtime = outageSince.getOutage() / 1000L;
                    int hrs = new Long(outtime / 3600L).intValue();
                    int remain = new Long(outtime % 3600L).intValue();
                    int mins = remain / 60;
                    int secs = remain %= 60;
                    LOG.debug("Outage : {} in mins {} hrs {} mins {} secs ", new Object[]{outtime, hrs, mins, secs});
                    value.setContent(hrs + " hrs " + mins + " mins " + secs + " secs ");
                    value.setType("data");
                    Value datevalue = new Value();
                    datevalue.setContent(fmt.format(new Date(outageSince.getOutTime())));
                    datevalue.setType("other");
                    Row row = new Row();
                    row.addValue(nodeValue);
                    row.addValue(value);
                    row.addValue(datevalue);
                    rows.addRow(row);
                    if (top20Count < 20) continue;
                    break block3;
                }
            }
            Col col = new Col();
            col.addColTitle(0, "Node Name");
            col.addColTitle(1, "Duration Of Outage");
            col.addColTitle(2, "Service Lost Time");
            ClassicTable table = new ClassicTable();
            table.setCol(col);
            table.setRows(rows);
            Section section = new Section();
            section.setClassicTable(table);
            section.setSectionName(label + " " + serviceEntry.getKey());
            section.setSectionTitle(label + " " + serviceEntry.getKey());
            section.setSectionDescr(descr + " " + serviceEntry.getKey());
            section.setSectionIndex(this.m_sectionIndex);
            ++this.m_sectionIndex;
            catSections.addSection(section);
        }
    }

    private void lastMTDDailyAvailability(int days, long endTime, CatSections sections, String label, String descr, String sectionName) {
        this.lastNDaysDailyAvailability(days, endTime, sections, label, descr, sectionName);
    }

    private void lastCalMTDDailyAvailability(int days, long endTime, CatSections sections, String label, String descr, String sectionName) {
        this.lastNDaysCalDailyAvailability(days, endTime, sections, label, descr, sectionName);
    }

    private void lastMoTotalAvailability(int days, long endTime, CatSections catSections, String label, String descr) {
        this.lastNDaysTotalAvailability(days, endTime, catSections, label, descr);
    }

    private void lastMoTopNOffenders(Map<Double, List<String>> offenders, CatSections catSections, String label, String descr) {
        LOG.debug("Offenders {}", offenders);
        LOG.debug("Inside lastMoTopNOffenders");
        Set<Map.Entry<Double, List<String>>> percentEntries = offenders.entrySet();
        Iterator<Map.Entry<Double, List<String>>> iter = percentEntries.iterator();
        Rows rows = new Rows();
        int top20Count = 0;
        block0: while (iter.hasNext()) {
            List<String> nodeNames;
            Map.Entry<Double, List<String>> percentEntry = iter.next();
            Double percent = percentEntry.getKey();
            if (!(percent < 100.0) || (nodeNames = percentEntry.getValue()) == null) continue;
            ListIterator<String> lstIter = nodeNames.listIterator();
            while (lstIter.hasNext()) {
                ++top20Count;
                String nodeName = lstIter.next();
                Value dateValue = new Value();
                dateValue.setContent(nodeName);
                dateValue.setType("title");
                Value value = new Value();
                value.setContent(this.formatNumber("" + percent));
                value.setType("data");
                Row row = new Row();
                row.addValue(dateValue);
                row.addValue(value);
                rows.addRow(row);
                if (top20Count < 20) continue;
                break block0;
            }
        }
        Col col = new Col();
        col.addColTitle(0, "Node Name");
        col.addColTitle(1, "Percentage Availability");
        ClassicTable table = new ClassicTable();
        table.setCol(col);
        table.setRows(rows);
        Section section = new Section();
        section.setClassicTable(table);
        section.setSectionName("lastMoTop20offenders");
        section.setSectionTitle(label);
        section.setSectionDescr(descr);
        section.setSectionIndex(this.m_sectionIndex);
        ++this.m_sectionIndex;
        catSections.addSection(section);
        LOG.debug("Leaving lastMoTopNOffenders");
    }

    private void lastMoDailyAvailability(int days, long endTime, CatSections sections, String label, String descr, String sectionName) {
        this.lastNDaysDailyAvailability(days, endTime, sections, label, descr, sectionName);
    }

    private void lastCalMoDailyAvailability(int days, long endTime, CatSections sections, String label, String descr, String sectionName) {
        this.lastNDaysCalDailyAvailability(days, endTime, sections, label, descr, sectionName);
    }

    private void lastNDaysCalDailyAvailability(int days, long endTime, CatSections catSections, String label, String descr, String sectionName) {
        LOG.debug("Inside lastNDaysDailyAvailability");
        int numdays = 0;
        CalendarTableBuilder calBuilder = new CalendarTableBuilder(endTime);
        TreeMap<Date, Double> treeMap = new TreeMap<Date, Double>();
        SimpleDateFormat fmt = new SimpleDateFormat("dd MMM, yyyy");
        String periodEnd = fmt.format(new Date(endTime));
        String periodFrom = "";
        while (numdays++ < days) {
            double percentAvail;
            LOG.debug("Computing for {}", (Object)new Date(endTime));
            int serviceCount = 0;
            long outage = 0L;
            for (Node node : this.m_nodes) {
                outage += node.getOutage(endTime, 86400000L);
                serviceCount += node.getServiceCount();
            }
            if (serviceCount > 0) {
                LOG.debug("LOOK: calculating percentAvail using outage {} service count {} ROLLING_WINODW {} endTime {}", new Object[]{endTime, outage, serviceCount, 86400000L});
                percentAvail = 100.0 * (1.0 - (double)outage * 1.0 / (1.0 * (double)serviceCount * 8.64E7));
            } else {
                percentAvail = 100.0;
            }
            treeMap.put(new Date(endTime), new Double(percentAvail));
            Date nicedate = new Date(endTime);
            LOG.debug("Inserting {} into {}", (Object)nicedate, (Object)percentAvail);
            periodFrom = fmt.format(new Date(endTime));
            endTime -= 86400000L;
        }
        int dateSlot = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            Double percent = (Double)entry.getValue();
            LOG.debug("Inserting value {} into date slot {}", (Object)(++dateSlot), (Object)percent);
            calBuilder.setPctValue(dateSlot, percent);
        }
        Section section = new Section();
        section.setCalendarTable(calBuilder.getTable());
        section.setSectionName(sectionName);
        section.setSectionTitle(label);
        section.setSectionDescr(descr);
        section.setPeriod(periodFrom + " to " + periodEnd);
        section.setSectionIndex(this.m_sectionIndex);
        ++this.m_sectionIndex;
        catSections.addSection(section);
        LOG.debug("Leaving lastNDaysCalDailyAvailability");
    }

    private void lastNDaysDailyAvailability(int days, long endTime, CatSections catSections, String label, String descr, String sectionName) {
        LOG.debug("Inside lastNDaysDailyAvailability");
        int numdays = 0;
        Rows rows = new Rows();
        TreeMap<Date, String> treeMap = new TreeMap<Date, String>();
        SimpleDateFormat fmt = new SimpleDateFormat("dd MMM, yyyy");
        String periodEnd = fmt.format(new Date(endTime));
        String periodFrom = "";
        while (numdays++ < days) {
            LOG.debug("Computing for {}", (Object)new Date(endTime));
            int serviceCount = 0;
            long outage = 0L;
            for (Node node : this.m_nodes) {
                outage += node.getOutage(endTime, 86400000L);
                serviceCount += node.getServiceCount();
            }
            double percentAvail = serviceCount > 0 ? 100.0 * (1.0 - (double)outage * 1.0 / (1.0 * (double)serviceCount * 8.64E7)) : 100.0;
            treeMap.put(new Date(endTime), this.formatNumber("" + percentAvail));
            periodFrom = fmt.format(new Date(endTime));
            endTime -= 86400000L;
        }
        SimpleDateFormat fmtmp = new SimpleDateFormat("dd");
        for (Map.Entry entry : treeMap.entrySet()) {
            Date key = (Date)entry.getKey();
            String percent = (String)entry.getValue();
            Value dateValue = new Value();
            dateValue.setContent(fmtmp.format(key));
            dateValue.setType("title");
            Value value = new Value();
            value.setContent(percent);
            value.setType("data");
            Row row = new Row();
            row.addValue(dateValue);
            row.addValue(value);
            rows.addRow(row);
        }
        Col col = new Col();
        col.addColTitle(0, "Date");
        col.addColTitle(1, "Percentage Availability");
        ClassicTable table = new ClassicTable();
        table.setCol(col);
        table.setRows(rows);
        Section section = new Section();
        section.setClassicTable(table);
        section.setSectionName(sectionName);
        section.setSectionTitle(label);
        section.setSectionDescr(descr);
        section.setPeriod(periodFrom + " to " + periodEnd);
        section.setSectionIndex(this.m_sectionIndex);
        ++this.m_sectionIndex;
        catSections.addSection(section);
        LOG.debug("Leaving lastNDaysDailyAvailability");
    }

    private void lastNDaysTotalAvailability(int days, long endTime, CatSections catSections, String label, String descr) {
        LOG.debug("Inside lastNDaysTotalAvailability");
        Rows rows = new Rows();
        int serviceCount = 0;
        long outage = 0L;
        int numdays = 0;
        SimpleDateFormat fmt = new SimpleDateFormat("dd MMM, yyyy");
        String periodEnd = fmt.format(new Date(endTime));
        Object periodFrom = "";
        while (numdays++ < days) {
            for (Node node : this.m_nodes) {
                serviceCount += node.getServiceCount();
                outage += node.getOutage(endTime, 86400000L);
            }
            periodFrom = fmt.format(new Date(endTime)) + " to " + periodEnd;
            endTime -= 86400000L;
        }
        double percentAvail = serviceCount > 0 ? 100.0 * (1.0 - (double)outage * 1.0 / (1.0 * (double)serviceCount * 8.64E7)) : 100.0;
        Value dateValue = new Value();
        dateValue.setContent((String)periodFrom);
        dateValue.setType("title");
        Value value = new Value();
        value.setContent(this.formatNumber("" + percentAvail));
        value.setType("data");
        Row row = new Row();
        row.addValue(dateValue);
        row.addValue(value);
        rows.addRow(row);
        Col col = new Col();
        col.addColTitle(0, "Date");
        col.addColTitle(1, "Percentage Availability");
        ClassicTable table = new ClassicTable();
        table.setCol(col);
        table.setRows(rows);
        Section section = new Section();
        section.setClassicTable(table);
        section.setSectionName("Last" + days + "TotalAvailability");
        section.setSectionTitle(label);
        section.setSectionDescr(descr);
        section.setPeriod((String)periodFrom);
        section.setSectionIndex(this.m_sectionIndex);
        ++this.m_sectionIndex;
        catSections.addSection(section);
        LOG.debug("Leaving lastNDaysTotalAvailability");
    }

    private void lastNMonthsAvailability(int nMonths, long endTime, CatSections catSections, String label, String descr) {
        LOG.debug("Inside lastNMonthsAvailability");
        Rows rows = new Rows();
        int numMonths = 0;
        int numDays = this.getDaysForMonth(endTime);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(endTime));
        int month = calendar.get(2);
        int year = calendar.get(1);
        calendar.set(year, month, numDays, 23, 59, 59);
        endTime = calendar.getTime().getTime();
        SimpleDateFormat fmt = new SimpleDateFormat("MMM, yyyy");
        String periodEnd = fmt.format(new Date(endTime));
        TreeMap<Date, String> treeMap = new TreeMap<Date, String>();
        String periodFrom = null;
        while (numMonths++ < nMonths) {
            int serviceCount = 0;
            long outage = 0L;
            LOG.debug("Number of days {} in month of {}", (Object)numDays, (Object)new Date(endTime));
            long rollingWindow = (long)numDays * 86400000L * 1L;
            for (Node node : this.m_nodes) {
                serviceCount += node.getServiceCount();
                outage += node.getOutage(endTime, rollingWindow);
            }
            double percentAvail = serviceCount > 0 ? 100.0 * (1.0 - (double)outage * 1.0 / (1.0 * (double)serviceCount * (double)rollingWindow)) : 100.0;
            treeMap.put(new Date(endTime), this.formatNumber("" + percentAvail));
            periodFrom = fmt.format(new Date(endTime));
            calendar = new GregorianCalendar();
            calendar.setTime(new Date(endTime));
            month = calendar.get(2);
            year = calendar.get(1);
            calendar.set(year, month - 1, 1, 0, 0, 0);
            endTime = calendar.getTime().getTime();
            month = calendar.get(2);
            year = calendar.get(1);
            numDays = this.getDaysForMonth(endTime);
            calendar.set(year, month, numDays, 23, 59, 59);
            endTime = calendar.getTime().getTime();
        }
        SimpleDateFormat fmtmp = new SimpleDateFormat("MMM");
        for (Map.Entry entry : treeMap.entrySet()) {
            Date key = (Date)entry.getKey();
            String percent = (String)entry.getValue();
            Value dateValue = new Value();
            dateValue.setContent(fmtmp.format(key));
            dateValue.setType("title");
            Value value = new Value();
            value.setContent(percent);
            value.setType("data");
            Row row = new Row();
            row.addValue(dateValue);
            row.addValue(value);
            rows.addRow(row);
        }
        Col col = new Col();
        col.addColTitle(0, "Date");
        col.addColTitle(1, "Percentage Availability");
        ClassicTable table = new ClassicTable();
        table.setCol(col);
        table.setRows(rows);
        Section section = new Section();
        section.setClassicTable(table);
        section.setSectionName("last12MoAvail");
        section.setSectionTitle(label);
        section.setSectionDescr(descr);
        section.setPeriod(periodFrom + " to " + periodEnd);
        section.setSectionIndex(this.m_sectionIndex);
        ++this.m_sectionIndex;
        catSections.addSection(section);
        LOG.debug("Leaving lastNMonthsAvailability");
    }

    private static synchronized int getDays(boolean isLeap, int month) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                if (isLeap) {
                    return 29;
                }
                return 28;
            }
        }
        return -1;
    }

    private int getDaysForMonth(long endTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(endTime));
        int month = calendar.get(2);
        int year = calendar.get(1);
        return AvailCalculations.getDays(calendar.isLeapYear(year), month);
    }

    private void lastNDaysDailyServiceAvailability(int days, long endTime, CatSections catSections, String label, String descr) {
        LOG.debug("Inside lastNDaysDailyServiceAvailability {}", (Object)days);
        SimpleDateFormat fmtmp = new SimpleDateFormat("dd MMM, yyyy");
        String periodFrom = "";
        String periodTo = "";
        periodTo = fmtmp.format(new Date(endTime));
        for (String service : this.m_monitoredServices) {
            Section section;
            ClassicTable table;
            Col col;
            SimpleDateFormat fmt;
            int daysCnt;
            TreeMap<Date, Double> treeMap = new TreeMap<Date, Double>();
            Rows rows = new Rows();
            LOG.debug("SERvice {}", (Object)service);
            long curTime = endTime;
            Map<IfService, OutageSvcTimesList> svcOutages = null;
            if (this.m_services != null) {
                svcOutages = this.m_services.get(service);
            }
            if (svcOutages == null || svcOutages.size() <= 0) {
                daysCnt = 0;
                while (daysCnt++ < days) {
                    LOG.debug("DAy 100 % : {}", (Object)daysCnt);
                    periodFrom = fmtmp.format(new Date(curTime));
                    treeMap.put(new Date(curTime), new Double(100.0));
                    curTime -= 86400000L;
                }
                fmt = new SimpleDateFormat("dd");
                for (Date tmp : treeMap.keySet()) {
                    Value dateValue = new Value();
                    dateValue.setContent(fmt.format(tmp));
                    dateValue.setType("title");
                    Value value = new Value();
                    value.setContent("100.0");
                    value.setType("data");
                    Row row = new Row();
                    row.addValue(dateValue);
                    row.addValue(value);
                    rows.addRow(row);
                }
                col = new Col();
                col.addColTitle(0, "Date");
                col.addColTitle(1, "Percentage Availability");
                table = new ClassicTable();
                table.setCol(col);
                table.setRows(rows);
                section = new Section();
                section.setClassicTable(table);
                section.setPeriod(periodFrom + " to " + periodTo);
                section.setSectionName(label + " " + service);
                section.setSectionTitle(label + " " + service);
                section.setSectionDescr(descr + " " + service);
                section.setSectionIndex(this.m_sectionIndex);
                ++this.m_sectionIndex;
                catSections.addSection(section);
                continue;
            }
            daysCnt = 0;
            while (daysCnt++ < days) {
                LOG.debug("DAy : {} end time {} ROLLING_WINDOW {}", new Object[]{daysCnt, new Date(curTime), 86400000L});
                int serviceCnt = 0;
                long outageTime = 0L;
                for (Map.Entry<IfService, OutageSvcTimesList> entry : svcOutages.entrySet()) {
                    IfService ifservice = entry.getKey();
                    OutageSvcTimesList outageList = entry.getValue();
                    LOG.debug(ifservice.toString());
                    if (outageList != null) {
                        long outage = outageList.getDownTime(curTime, 86400000L);
                        outageTime += outage;
                    }
                    ++serviceCnt;
                }
                LOG.debug("Outage Time {}", (Object)outageTime);
                long den = 86400000L * (long)serviceCnt;
                double outag = 1.0 * (double)outageTime;
                double denom = 1.0 * (double)den;
                double cal = 0.0;
                if (den > 0L) {
                    cal = 100.0 * (1.0 - outag / denom);
                }
                treeMap.put(new Date(curTime), new Double(cal));
                periodFrom = fmtmp.format(new Date(curTime));
                LOG.debug("Added to svc list {}", (Object)new Date(curTime));
                curTime -= 86400000L;
            }
            fmt = new SimpleDateFormat("dd");
            for (Map.Entry entry : treeMap.entrySet()) {
                Date tmp = (Date)entry.getKey();
                Double val = (Double)entry.getValue();
                Value dateValue = new Value();
                dateValue.setContent(fmt.format(tmp));
                dateValue.setType("title");
                Value value = new Value();
                value.setContent("" + val);
                value.setType("data");
                Row row = new Row();
                row.addValue(dateValue);
                row.addValue(value);
                rows.addRow(row);
            }
            col = new Col();
            col.addColTitle(0, "Date");
            col.addColTitle(1, "Percentage Availability");
            table = new ClassicTable();
            table.setCol(col);
            table.setRows(rows);
            section = new Section();
            section.setClassicTable(table);
            section.setPeriod(periodFrom + " to " + periodTo);
            section.setSectionName(label + " " + service);
            section.setSectionTitle(label + " " + service);
            section.setSectionDescr(descr + " " + service);
            section.setSectionIndex(this.m_sectionIndex);
            ++this.m_sectionIndex;
            catSections.addSection(section);
        }
        LOG.debug("Leaving lastNDaysDailyServiceAvailability");
    }

    private String formatNumber(String num) {
        if (((String)num).indexOf(46) == 0) {
            num = "0" + (String)num;
        }
        if (((String)num).indexOf(46) == -1) {
            num = (String)num + ".0";
        }
        num = (String)num + "000000";
        return ((String)num).substring(0, ((String)num).indexOf(46) + 6);
    }
}

