/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo.support;

import java.io.IOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenPersistenceManagerInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_PERSISTENCE_MANAGER_FACTORY_BEAN_NAME = "persistenceManagerFactory";
    private String persistenceManagerFactoryBeanName = "persistenceManagerFactory";

    public void setPersistenceManagerFactoryBeanName(String persistenceManagerFactoryBeanName) {
        this.persistenceManagerFactoryBeanName = persistenceManagerFactoryBeanName;
    }

    protected String getPersistenceManagerFactoryBeanName() {
        return this.persistenceManagerFactoryBeanName;
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        PersistenceManagerFactory pmf = this.lookupPersistenceManagerFactory(request);
        boolean participate = false;
        if (TransactionSynchronizationManager.hasResource((Object)pmf)) {
            participate = true;
        } else {
            this.logger.debug((Object)"Opening JDO PersistenceManager in OpenPersistenceManagerInViewFilter");
            PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(pmf, true);
            TransactionSynchronizationManager.bindResource((Object)pmf, (Object)((Object)new PersistenceManagerHolder(pm)));
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (!participate) {
                PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)pmf));
                this.logger.debug((Object)"Closing JDO PersistenceManager in OpenPersistenceManagerInViewFilter");
                PersistenceManagerFactoryUtils.releasePersistenceManager(pmHolder.getPersistenceManager(), pmf);
            }
        }
    }

    protected PersistenceManagerFactory lookupPersistenceManagerFactory(HttpServletRequest request) {
        return this.lookupPersistenceManagerFactory();
    }

    protected PersistenceManagerFactory lookupPersistenceManagerFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using PersistenceManagerFactory '" + this.getPersistenceManagerFactoryBeanName() + "' for OpenPersistenceManagerInViewFilter"));
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (PersistenceManagerFactory)wac.getBean(this.getPersistenceManagerFactoryBeanName(), PersistenceManagerFactory.class);
    }
}

