/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.state;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;

public class ParserState {
    public final List<String> connections;

    private ParserState(Builder builder) {
        this.connections = builder.connections.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<String> connections = ImmutableList.builder();

        private Builder() {
        }

        public Builder withConnection(InetAddress connection) {
            this.connections.add((Object)InetAddressUtils.str((InetAddress)connection));
            return this;
        }

        public Builder withConnections(Set<InetAddress> connections) {
            connections.forEach(this::withConnection);
            return this;
        }

        public ParserState build() {
            return new ParserState(this);
        }
    }
}

