/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Attribute;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;

public class Aggregator
implements Attribute {
    public final int as;
    public final InetAddress address;

    public Aggregator(ByteBuf buffer, PeerFlags flags) {
        if (buffer.readableBytes() < 6) {
            throw new IllegalArgumentException("Insufficient bytes for Aggregator attribute: expected at least 6 bytes, got " + buffer.readableBytes());
        }
        this.as = BufferUtils.uint16((ByteBuf)buffer);
        try {
            this.address = InetAddress.getByAddress(BufferUtils.bytes((ByteBuf)buffer, (int)4));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IP address in Aggregator attribute", e);
        }
    }

    @Override
    public void accept(Attribute.Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("as", this.as).add("address", (Object)this.address).toString();
    }
}

