/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import com.vaadin.event.Action;
import com.vaadin.shared.ui.MultiSelectMode;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.Tree;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansController;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MbeansHierarchicalContainer;

class MBeansTree
extends Tree
implements Action.Handler {
    private final MBeansController controller;
    private final MbeansHierarchicalContainer container;
    private final Action SELECT = new Action("select");
    private final Action DESELECT = new Action("deselect");
    private final Action[] ACTIONS = new Action[]{this.SELECT, this.DESELECT};

    protected MBeansTree(final MBeansController controller) {
        this.container = controller.getMBeansHierarchicalContainer();
        this.controller = controller;
        this.setSizeFull();
        this.setContainerDataSource((Container)this.container);
        this.setItemCaptionPropertyId("label");
        this.setItemIconPropertyId("icon");
        this.setItemDescriptionGenerator(new AbstractSelect.ItemDescriptionGenerator(){

            public String generateDescription(Component source, Object itemId, Object propertyId) {
                return MBeansTree.this.getItem(itemId).getItemProperty((Object)"caption").getValue().toString();
            }
        });
        this.setItemStyleGenerator(new Tree.ItemStyleGenerator(){

            public String getStyle(Tree source, Object itemId) {
                if (((Boolean)source.getItem(itemId).getItemProperty((Object)"valid").getValue()).booleanValue()) {
                    return "";
                }
                return "invalid";
            }
        });
        this.setSelectable(true);
        this.setMultiSelect(false);
        this.setNullSelectionAllowed(true);
        this.setMultiselectMode(MultiSelectMode.SIMPLE);
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){

            public void itemClick(ItemClickEvent event) {
                Object itemId = event.getItemId();
                if (itemId instanceof String) {
                    controller.selectItemInTree((String)itemId);
                }
            }
        });
        this.setImmediate(true);
        this.addActionHandler(this);
        this.setValidationVisible(false);
    }

    public void expandAllItems() {
        for (Object itemId : this.rootItemIds()) {
            this.expandItemsRecursively(itemId);
        }
    }

    public void expandItemsUpToParent(String startItemId) {
        if (startItemId != null) {
            this.expandItem(startItemId);
            String parentItemId = (String)this.getParent(startItemId);
            this.expandItemsUpToParent(parentItemId);
        }
    }

    public Action[] getActions(Object target, Object sender) {
        return this.ACTIONS;
    }

    public void handleAction(Action action, Object sender, Object target) {
        if (action == this.SELECT) {
            this.controller.handleSelectDeselect(this.container.getItem(target), target, true);
        }
        if (action == this.DESELECT) {
            this.controller.handleSelectDeselect(this.container.getItem(target), target, false);
        }
        this.fireValueChange(false);
    }

    public static interface MetaMBeansTreeItem {
        public static final String TOOLTIP = "caption";
        public static final String ICON = "icon";
        public static final String CAPTION = "label";
        public static final String SELECTED = "selected";
        public static final String VALID = "valid";
    }
}

