/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.util.Collection;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.model.LldpElement;
import org.opennms.netmgt.enlinkd.snmp.LldpLocPortGetter;
import org.opennms.netmgt.enlinkd.snmp.LldpSnmpUtils;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LldpLocalTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(LldpLocalTableTracker.class);
    public static final SnmpObjId[] s_lldploctable_elemList = new SnmpObjId[]{LldpLocPortGetter.LLDP_LOC_PORTID_SUBTYPE_OID, LldpLocPortGetter.LLDP_LOC_PORTID_OID, LldpLocPortGetter.LLDP_LOC_DESCR_OID};

    public LldpLocalTableTracker() {
        super(s_lldploctable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new LldpLocalPortRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processLldpLocPortRow((LldpLocalPortRow)row);
    }

    public void processLldpLocPortRow(LldpLocalPortRow row) {
        System.out.printf("\t\t%s (%s)= %s (%s)\n", String.valueOf(LldpLocPortGetter.LLDP_LOC_PORTID_SUBTYPE_OID) + "." + row.getInstance().toString(), "lldpLocPortIdSubtype", row.getLldpLocalPortIdSubtype(), LldpUtils.LldpPortIdSubType.getTypeString((Integer)row.getLldpLocalPortIdSubtype().getValue()));
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(LldpLocPortGetter.LLDP_LOC_PORTID_OID) + "." + row.getInstance().toString(), "lldpLocPortId", row.getLldpLocPortId());
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(LldpLocPortGetter.LLDP_LOC_DESCR_OID) + "." + row.getInstance().toString(), "lldpLocPortDesc", row.getLldpLocPortDesc());
    }

    public static LldpElement getLldpElement(String sysname, Collection<LldpLocalPortRow> rows) {
        LldpElement element = new LldpElement();
        element.setLldpSysname(sysname);
        for (LldpLocalPortRow row : rows) {
            if (!row.getLldpLocalPortIdSubtype().equals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_MACADDRESS)) continue;
            LOG.debug("getLldpElement: parsing lldp_chassis_id {}", (Object)row.getLldpLocPortId());
            if (element.getLldpChassisId() != null && element.getLldpChassisId().compareTo(row.getLldpLocPortId()) <= 0) continue;
            LOG.debug("getLldpElement: set lldp_chassis_id {}", (Object)row.getLldpLocPortId());
            element.setLldpChassisIdSubType(LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_MACADDRESS);
            element.setLldpChassisId(row.getLldpLocPortId());
        }
        if (element.getLldpChassisId() == null) {
            element.setLldpChassisIdSubType(LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_LOCAL);
            element.setLldpChassisId(sysname);
        }
        LOG.info("getLldpElement: {}", (Object)element);
        return element;
    }

    public static class LldpLocalPortRow
    extends SnmpRowResult {
        public LldpLocalPortRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getMtxrIndex() {
            return this.getInstance().getSubIdAt(0);
        }

        public LldpUtils.LldpPortIdSubType getLldpLocalPortIdSubtype() {
            return LldpUtils.LldpPortIdSubType.get((Integer)this.getValue(LldpLocPortGetter.LLDP_LOC_PORTID_SUBTYPE_OID).toInt());
        }

        public String getLldpLocPortId() {
            return LldpSnmpUtils.decodeLldpPortId(this.getLldpLocalPortIdSubtype(), this.getValue(LldpLocPortGetter.LLDP_LOC_PORTID_OID));
        }

        public String getLldpLocPortDesc() {
            if (this.getValue(LldpLocPortGetter.LLDP_LOC_DESCR_OID) != null) {
                return this.getValue(LldpLocPortGetter.LLDP_LOC_DESCR_OID).toDisplayString();
            }
            return "";
        }
    }
}

