/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm.filter;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.filter.SQLType;

public class NegativeCategoryFilter
extends OneArgFilter<String> {
    public static final String TYPE = "categoryNot";
    public static final String NESTED_TYPE = "nestedCategoryNot";

    public NegativeCategoryFilter(String category) {
        super(TYPE, SQLType.STRING, "NODEID", "nodeid", category);
    }

    @Override
    public String getSQLTemplate() {
        return " " + this.getSQLFieldName() + " NOT IN (SELECT CN.NODEID FROM CATEGORY_NODE CN, CATEGORIES C WHERE CN.CATEGORYID = C.CATEGORYID AND C.CATEGORYNAME = %s) ";
    }

    @Override
    public Criterion getCriterion() {
        return Restrictions.sqlRestriction((String)(" {alias}." + this.getSQLFieldName() + " NOT IN (SELECT CN.NODEID FROM CATEGORY_NODE CN, CATEGORIES C WHERE CN.CATEGORYID = C.CATEGORYID AND C.CATEGORYNAME = ?)"), (Object[])new Object[]{this.getValue()}, (Type[])new Type[]{StringType.INSTANCE});
    }

    @Override
    public String getTextDescription() {
        return "category is not \"" + (String)this.getValue() + "\"";
    }

    @Override
    public String toString() {
        return "<AlarmFactory.NegativeCategoryFilter: " + this.getDescription() + ">";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NegativeCategoryFilter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

