/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.api.Util;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.element.Service;
import org.opennms.web.servlet.MissingParameterException;

public class DeleteServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = -8169359759001371089L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.checkParameters(request);
        int nodeId = WebSecurityUtils.safeParseInt((String)request.getParameter("node"));
        String ipAddr = request.getParameter("intf");
        int serviceId = WebSecurityUtils.safeParseInt((String)request.getParameter("service"));
        Service service_db = NetworkElementFactory.getInstance(this.getServletContext()).getService(nodeId, ipAddr, serviceId);
        if (service_db == null) {
            throw new ServletException("No such service in database");
        }
        Event e = EventUtils.createDeleteServiceEvent((String)"OpenNMS.WebUI", (long)nodeId, (String)ipAddr, (String)service_db.getServiceName(), (long)-1L);
        this.sendEvent(e);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/serviceDeleted.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void checkParameters(HttpServletRequest request) {
        String nodeIdString = request.getParameter("node");
        String ipAddr = request.getParameter("intf");
        String serviceId = request.getParameter("service");
        if (nodeIdString == null) {
            throw new MissingParameterException("node", new String[]{"node", "intf", "service", "ifindex?"});
        }
        if (ipAddr == null) {
            throw new MissingParameterException("intf", new String[]{"node", "intf", "service", "ifindex?"});
        }
        if (serviceId == null) {
            throw new MissingParameterException("service", new String[]{"node", "intf", "service", "ifindex?"});
        }
    }

    private void sendEvent(Event event) throws ServletException {
        try {
            Util.createEventProxy().send(event);
        }
        catch (Throwable e) {
            throw new ServletException("Could not send event " + event.getUei(), e);
        }
    }
}

