/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.generic;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.graph.api.validation.NamespaceValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericElement {
    private static final Logger LOG = LoggerFactory.getLogger(GenericElement.class);
    protected final Map<String, Object> properties;

    protected GenericElement(Map<String, Object> properties) {
        Objects.requireNonNull(properties);
        this.properties = ImmutableMap.copyOf(properties);
        new NamespaceValidator().validate(this.getNamespace());
    }

    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    public <T> T getProperty(String key, T defaultValue) {
        return (T)this.properties.getOrDefault(key, defaultValue);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getNamespace() {
        return (String)this.getProperty("namespace");
    }

    public String getLabel() {
        return (String)this.getProperty("label");
    }

    public String getId() {
        return (String)this.getProperty("id");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericElement that = (GenericElement)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("properties", this.properties).toString();
    }

    public static abstract class GenericElementBuilder<T extends GenericElementBuilder> {
        protected final Map<String, Object> properties = new HashMap<String, Object>();
        protected final NamespaceValidator namespaceValidator = new NamespaceValidator();

        protected GenericElementBuilder() {
        }

        public T id(String id) {
            this.property("id", id);
            return (T)this;
        }

        public T label(String label) {
            this.property("label", label);
            return (T)this;
        }

        public T namespace(String namespace) {
            Objects.requireNonNull(namespace, "namespace cannot be null.");
            this.property("namespace", namespace);
            return (T)this;
        }

        public T property(String name, Object value) {
            if (name == null || value == null) {
                LOG.debug("Property name ({}) or value ({}) is null => ignoring it.", (Object)name, value);
                return (T)this;
            }
            if ("namespace".equals(name)) {
                this.namespaceValidator.validate((String)value);
            }
            this.properties.put(name, value);
            return (T)this;
        }

        public T properties(Map<String, Object> properties) {
            Objects.requireNonNull(properties, "properties cannot be null");
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.property(entry.getKey(), entry.getValue());
            }
            return (T)this;
        }

        public String getNamespace() {
            return (String)this.properties.get("namespace");
        }

        public String getId() {
            return (String)this.properties.get("id");
        }
    }
}

