/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.asteriskjava.live.AsteriskServer;
import org.asteriskjava.live.LiveObject;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

abstract class AbstractLiveObject
implements LiveObject {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final PropertyChangeSupport changes;
    protected final AsteriskServerImpl server;

    AbstractLiveObject(AsteriskServerImpl server) {
        this.server = server;
        this.changes = new PropertyChangeSupport(this);
    }

    @Override
    public AsteriskServer getServer() {
        return this.server;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null || newValue != null) {
            try {
                this.changes.firePropertyChange(propertyName, oldValue, newValue);
            }
            catch (Exception e) {
                this.logger.warn("Uncaught exception in PropertyChangeListener", e);
            }
        }
    }
}

