/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.util.AstUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AgiRequestImpl
implements AgiRequest {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final Pattern SCRIPT_PATTERN = Pattern.compile("^([^\\?]*)\\?(.*)$");
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("^(.*)=(.*)$");
    private String rawCallerId;
    private Map<String, String> request;
    private Map<String, String[]> parameterMap;
    private String[] arguments;
    private String parameters;
    private String script;
    private boolean callerIdCreated;
    private InetAddress localAddress;
    private int localPort;
    private InetAddress remoteAddress;
    private int remotePort;

    AgiRequestImpl(List<String> environment) {
        this(AgiRequestImpl.buildMap(environment));
    }

    private AgiRequestImpl(Map<String, String> request) {
        Matcher scriptMatcher;
        this.request = request;
        this.script = request.get("network_script");
        if (this.script != null && (scriptMatcher = SCRIPT_PATTERN.matcher(this.script)).matches()) {
            this.script = scriptMatcher.group(1);
            this.parameters = scriptMatcher.group(2);
        }
    }

    private static Map<String, String> buildMap(Collection<String> lines) throws IllegalArgumentException {
        if (lines == null) {
            throw new IllegalArgumentException("Environment must not be null.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : lines) {
            int colonPosition = line.indexOf(58);
            if (colonPosition < 0 || !line.startsWith("agi_") && !line.startsWith("ogi_") || line.length() < colonPosition + 2) continue;
            String key = line.substring(4, colonPosition).toLowerCase(Locale.ENGLISH);
            String value = line.substring(colonPosition + 2);
            if (value.length() == 0) continue;
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Map<String, String> getRequest() {
        return this.request;
    }

    @Override
    public synchronized String getScript() {
        return this.script;
    }

    @Override
    public String getRequestURL() {
        return this.request.get("request");
    }

    @Override
    public String getChannel() {
        return this.request.get("channel");
    }

    @Override
    public String getUniqueId() {
        return this.request.get("uniqueid");
    }

    @Override
    public String getType() {
        return this.request.get("type");
    }

    @Override
    public String getLanguage() {
        return this.request.get("language");
    }

    @Override
    @Deprecated
    public String getCallerId() {
        return this.getCallerIdNumber();
    }

    @Override
    public String getCallerIdNumber() {
        String callerIdName = this.request.get("calleridname");
        String callerId = this.request.get("callerid");
        if (callerIdName != null) {
            if (callerId == null || "unknown".equals(callerId)) {
                return null;
            }
            return callerId;
        }
        return this.getCallerId10();
    }

    @Override
    public String getCallerIdName() {
        String callerIdName = this.request.get("calleridname");
        if (callerIdName != null) {
            if ("unknown".equals(callerIdName)) {
                return null;
            }
            return callerIdName;
        }
        return this.getCallerIdName10();
    }

    private synchronized String getCallerId10() {
        String[] parsedCallerId;
        if (!this.callerIdCreated) {
            this.rawCallerId = this.request.get("callerid");
            this.callerIdCreated = true;
        }
        if ((parsedCallerId = AstUtil.parseCallerId(this.rawCallerId))[1] == null) {
            return parsedCallerId[0];
        }
        return parsedCallerId[1];
    }

    private synchronized String getCallerIdName10() {
        if (!this.callerIdCreated) {
            this.rawCallerId = this.request.get("callerid");
            this.callerIdCreated = true;
        }
        return AstUtil.parseCallerId(this.rawCallerId)[0];
    }

    @Override
    public String getDnid() {
        String dnid = this.request.get("dnid");
        if (dnid == null || "unknown".equals(dnid)) {
            return null;
        }
        return dnid;
    }

    @Override
    public String getRdnis() {
        String rdnis = this.request.get("rdnis");
        if (rdnis == null || "unknown".equals(rdnis)) {
            return null;
        }
        return rdnis;
    }

    @Override
    public String getContext() {
        return this.request.get("context");
    }

    @Override
    public String getExtension() {
        return this.request.get("extension");
    }

    @Override
    public Integer getPriority() {
        if (this.request.get("priority") != null) {
            return Integer.valueOf(this.request.get("priority"));
        }
        return null;
    }

    @Override
    public Boolean getEnhanced() {
        if (this.request.get("enhanced") != null) {
            if ("1.0".equals(this.request.get("enhanced"))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public String getAccountCode() {
        return this.request.get("accountcode");
    }

    @Override
    public Integer getCallingAni2() {
        if (this.request.get("callingani2") == null) {
            return null;
        }
        try {
            return Integer.valueOf(this.request.get("callingani2"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Integer getCallingPres() {
        if (this.request.get("callingpres") == null) {
            return null;
        }
        try {
            return Integer.valueOf(this.request.get("callingpres"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Integer getCallingTns() {
        if (this.request.get("callingtns") == null) {
            return null;
        }
        try {
            return Integer.valueOf(this.request.get("callingtns"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Integer getCallingTon() {
        if (this.request.get("callington") == null) {
            return null;
        }
        try {
            return Integer.valueOf(this.request.get("callington"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    @Override
    public synchronized String[] getParameterValues(String name) {
        if (this.getParameterMap().isEmpty()) {
            return new String[0];
        }
        String[] values = this.parameterMap.get(name);
        return values == null ? new String[]{} : values;
    }

    @Override
    public synchronized Map<String, String[]> getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = this.parseParameters(this.parameters);
        }
        return this.parameterMap;
    }

    private synchronized Map<String, String[]> parseParameters(String s) {
        HashMap parameterMap = new HashMap();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        if (s == null) {
            return result;
        }
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            List<String> values;
            String value;
            String name;
            block9: {
                String parameter = st.nextToken();
                Matcher parameterMatcher = PARAMETER_PATTERN.matcher(parameter);
                if (parameterMatcher.matches()) {
                    try {
                        name = URLDecoder.decode(parameterMatcher.group(1), "UTF-8");
                        value = URLDecoder.decode(parameterMatcher.group(2), "UTF-8");
                        break block9;
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.error("Unable to decode parameter '" + parameter + "'", e);
                        continue;
                    }
                }
                try {
                    name = URLDecoder.decode(parameter, "UTF-8");
                    value = "";
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.error("Unable to decode parameter '" + parameter + "'", e);
                    continue;
                }
            }
            if (parameterMap.get(name) == null) {
                values = new ArrayList<String>();
                values.add(value);
                parameterMap.put(name, values);
                continue;
            }
            values = (List)parameterMap.get(name);
            values.add(value);
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] valueArray = new String[((List)entry.getValue()).size()];
            result.put((String)entry.getKey(), ((List)entry.getValue()).toArray(valueArray));
        }
        return result;
    }

    @Override
    public synchronized String[] getArguments() {
        if (this.arguments != null) {
            return (String[])this.arguments.clone();
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int maxIndex = 0;
        for (Map.Entry<String, String> entry : this.request.entrySet()) {
            if (!entry.getKey().startsWith("arg_")) continue;
            int index = Integer.valueOf(entry.getKey().substring(4));
            if (index > maxIndex) {
                maxIndex = index;
            }
            map.put(index, entry.getValue());
        }
        this.arguments = new String[maxIndex];
        for (int i = 0; i < maxIndex; ++i) {
            this.arguments[i] = (String)map.get(i + 1);
        }
        return (String[])this.arguments.clone();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    void setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    void setRemoteAddress(InetAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AgiRequest[");
        sb.append("script='").append(this.getScript()).append("',");
        sb.append("requestURL='").append(this.getRequestURL()).append("',");
        sb.append("channel='").append(this.getChannel()).append("',");
        sb.append("uniqueId='").append(this.getUniqueId()).append("',");
        sb.append("type='").append(this.getType()).append("',");
        sb.append("language='").append(this.getLanguage()).append("',");
        sb.append("callerIdNumber='").append(this.getCallerIdNumber()).append("',");
        sb.append("callerIdName='").append(this.getCallerIdName()).append("',");
        sb.append("dnid='").append(this.getDnid()).append("',");
        sb.append("rdnis='").append(this.getRdnis()).append("',");
        sb.append("context='").append(this.getContext()).append("',");
        sb.append("extension='").append(this.getExtension()).append("',");
        sb.append("priority='").append(this.getPriority()).append("',");
        sb.append("enhanced='").append(this.getEnhanced()).append("',");
        sb.append("accountCode='").append(this.getAccountCode()).append("',");
        sb.append("systemHashcode=").append(System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }
}

