/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElement;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Semantics;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;

public class FloatValue
extends Value<Double> {
    private final double value;

    public FloatValue(String name, Optional<Semantics> semantics, double value) {
        super(name, semantics);
        this.value = Objects.requireNonNull(value);
    }

    public FloatValue(String name, double value) {
        this(name, Optional.empty(), value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("value", this.value).toString();
    }

    public static InformationElement parserWith32Bit(InformationElementDatabase database, final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(InformationElementDatabase database, Session.Resolver resolver, ByteBuf buffer) {
                return new FloatValue(name, semantics, Float.intBitsToFloat(BufferUtils.uint((ByteBuf)buffer, (int)buffer.readableBytes()).intValue()));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 4;
            }
        };
    }

    public static InformationElement parserWith64Bit(InformationElementDatabase database, final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(InformationElementDatabase database, Session.Resolver resolver, ByteBuf buffer) {
                return new FloatValue(name, semantics, Double.longBitsToDouble(BufferUtils.uint((ByteBuf)buffer, (int)buffer.readableBytes()).longValue()));
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 8;
            }
        };
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void visit(Value.Visitor visitor) {
        visitor.accept(this);
    }
}

