/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;

public class InvalidPacketException
extends Exception {
    public InvalidPacketException(ByteBuf buffer, String fmt, Object ... args) {
        super(InvalidPacketException.appendPosition(String.format(fmt, args), buffer));
    }

    public InvalidPacketException(InvalidPacketException cause, String fmt, Object ... args) {
        super(cause.getMessage() + "\n" + String.format(fmt, args), cause);
    }

    public InvalidPacketException(ByteBuf buffer, String message, Throwable cause) {
        super(InvalidPacketException.appendPosition(message, buffer), cause);
    }

    private static String appendPosition(String message, ByteBuf buffer) {
        ByteBuf unwrappedBuffer = Unpooled.wrappedUnmodifiableBuffer((ByteBuf[])new ByteBuf[]{buffer.unwrap() != null ? buffer.unwrap() : buffer}).resetReaderIndex();
        int delta = unwrappedBuffer.readableBytes() - (buffer.readableBytes() + buffer.readerIndex());
        int offset = buffer.readerIndex() + delta;
        return String.format("%s, Offset: [0x%04X], Payload:\n%s", message, offset, ByteBufUtil.prettyHexDump((ByteBuf)unwrappedBuffer));
    }
}

